/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.item;

import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.integrateddynamics.Capabilities;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.block.IFacadeable;
import org.cyclops.integrateddynamics.item.ItemBlockCable;

public class ItemFacade
extends Item {
    public ItemFacade(Item.Properties properties) {
        super(properties);
    }

    public BlockState getFacadeBlock(ItemStack itemStack) {
        return (BlockState)itemStack.get(RegistryEntries.DATACOMPONENT_FACADE_BLOCK);
    }

    public ItemStack getFacadeBlockItem(ItemStack itemStack) {
        BlockState blockState = this.getFacadeBlock(itemStack);
        if (blockState != null) {
            return IModHelpers.get().getBlockHelpers().getItemStackFromBlockState(blockState);
        }
        return null;
    }

    public void writeFacadeBlock(ItemStack itemStack, BlockState blockState) {
        itemStack.set(RegistryEntries.DATACOMPONENT_FACADE_BLOCK, (Object)blockState);
        MutableComponent itemName = Component.translatable((String)this.descriptionId);
        MutableComponent suffix = Component.translatable((String)"general.integrateddynamics.info.none").withStyle(ChatFormatting.ITALIC);
        ItemStack itemStackInner = this.getFacadeBlockItem(itemStack);
        if (itemStackInner != null) {
            suffix = this.getFacadeBlockItem(itemStack).getHoverName();
        }
        itemName = itemName.append(" - ").append((Component)suffix);
        itemStack.set(DataComponents.ITEM_NAME, (Object)itemName);
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack itemStack = context.getItemInHand();
        if (!context.getLevel().isClientSide()) {
            IFacadeable facadeable = IModHelpersNeoForge.get().getCapabilityHelpers().getCapability((ILevelExtension)context.getLevel(), context.getClickedPos(), null, Capabilities.Facadeable.BLOCK).orElse(null);
            BlockState blockState = this.getFacadeBlock(itemStack);
            if (facadeable != null && blockState != null && !facadeable.hasFacade()) {
                facadeable.setFacade(blockState);
                ItemBlockCable.playPlaceSound(context.getLevel(), context.getClickedPos());
                itemStack.shrink(1);
            }
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }
}

