/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.metadata;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.fluids.FluidStack;
import org.cyclops.cyclopscore.metadata.IRegistryExportable;
import org.cyclops.cyclopscore.metadata.RegistryExportableRecipeAbstract;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeSqueezer;

public class RegistryExportableSqueezerRecipe
extends RegistryExportableRecipeAbstract<RecipeType<RecipeSqueezer>, RecipeSqueezer, CraftingInput> {
    protected RegistryExportableSqueezerRecipe() {
        super(() -> RegistryEntries.RECIPETYPE_SQUEEZER.get());
    }

    public static JsonObject serializeRecipeStatic(RecipeSqueezer recipe) {
        JsonObject object = new JsonObject();
        List inputs = recipe.getInputIngredient().items().toList();
        JsonArray arrayInputs = new JsonArray();
        for (Holder input : inputs) {
            arrayInputs.add((JsonElement)IRegistryExportable.serializeItemStack((ItemStack)new ItemStack(input)));
        }
        JsonObject outputObject = new JsonObject();
        Optional<FluidStack> fluidOutput = recipe.getOutputFluid();
        fluidOutput.ifPresent(fluidStack -> outputObject.add("fluid", (JsonElement)IRegistryExportable.serializeFluidStack((FluidStack)fluidStack)));
        NonNullList<RecipeSqueezer.IngredientChance> itemOutputs = recipe.getOutputItems();
        JsonArray arrayItemOutputs = new JsonArray();
        boolean i = false;
        for (RecipeSqueezer.IngredientChance itemOutput : itemOutputs) {
            JsonObject itemOutputObject = IRegistryExportable.serializeItemStack((ItemStack)itemOutput.getIngredientFirst());
            float chance = itemOutput.getChance();
            if (chance > 0.0f) {
                itemOutputObject.addProperty("chance", (Number)Float.valueOf(chance));
            }
            arrayItemOutputs.add((JsonElement)itemOutputObject);
        }
        outputObject.add("items", (JsonElement)arrayItemOutputs);
        object.add("input", (JsonElement)arrayInputs);
        object.add("output", (JsonElement)outputObject);
        return object;
    }

    public JsonObject serializeRecipe(RecipeHolder<RecipeSqueezer> recipe) {
        return RegistryExportableSqueezerRecipe.serializeRecipeStatic((RecipeSqueezer)recipe.value());
    }
}

