/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamicscompat.modcompat.rei.squeezer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.display.RecipeDisplayId;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.material.Fluid;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.integrateddynamics.core.recipe.display.RecipeDisplaySqueezer;
import org.cyclops.integrateddynamicscompat.modcompat.rei.squeezer.ReiSqueezerCategory;
import org.jetbrains.annotations.Nullable;

public class ReiSqueezerRecipe
implements Display {
    public static final DisplaySerializer<ReiSqueezerRecipe> SERIALIZER = DisplaySerializer.of((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)RecipeDisplaySqueezer.MAP_CODEC.fieldOf("display").forGetter(ReiSqueezerRecipe::getRecipeDisplay), (App)Codec.INT.xmap(RecipeDisplayId::new, RecipeDisplayId::index).optionalFieldOf("id").forGetter(ReiSqueezerRecipe::recipeDisplayId)).apply((Applicative)instance, ReiSqueezerRecipe::new)), (StreamCodec)StreamCodec.composite(RecipeDisplaySqueezer.STREAM_CODEC, ReiSqueezerRecipe::getRecipeDisplay, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.INT.map(RecipeDisplayId::new, RecipeDisplayId::index)), ReiSqueezerRecipe::recipeDisplayId, ReiSqueezerRecipe::new), (boolean)false);
    private final RecipeDisplaySqueezer recipeDisplay;
    private final List<EntryIngredient> inputs;
    private final List<EntryIngredient> outputs;
    private final Optional<RecipeDisplayId> id;

    public ReiSqueezerRecipe(RecipeDisplaySqueezer recipeDisplay, Optional<RecipeDisplayId> id) {
        this.recipeDisplay = recipeDisplay;
        this.inputs = Lists.newArrayList();
        this.outputs = Lists.newArrayList();
        this.id = id;
        this.inputs.add(EntryIngredients.ofSlotDisplay((SlotDisplay)recipeDisplay.inputIngredient()));
        for (Pair<? extends SlotDisplay, Float> outputItem : recipeDisplay.outputItems()) {
            if (((Float)outputItem.getRight()).floatValue() != 1.0f) continue;
            this.outputs.add(EntryIngredients.ofSlotDisplay((SlotDisplay)((SlotDisplay)outputItem.getLeft())));
        }
        this.outputs.add(EntryIngredients.of((Fluid)recipeDisplay.outputFluid().getFluid(), (long)recipeDisplay.outputFluid().getAmount()));
    }

    public RecipeDisplaySqueezer getRecipeDisplay() {
        return this.recipeDisplay;
    }

    public List<EntryIngredient> getInputEntries() {
        return this.inputs;
    }

    public List<EntryIngredient> getOutputEntries() {
        return this.outputs;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return ReiSqueezerCategory.ID;
    }

    public Optional<RecipeDisplayId> recipeDisplayId() {
        return this.id;
    }

    public Optional<ResourceLocation> getDisplayLocation() {
        return Optional.empty();
    }

    @Nullable
    public DisplaySerializer<? extends Display> getSerializer() {
        return SERIALIZER;
    }
}

