/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.biome.v1;

import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import net.minecraft.util.random.Weighted;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.MobSpawnSettings;
import org.jetbrains.annotations.Nullable;

public interface MobSpawnSettingsContext {
    public void addSpawn(MobCategory var1, int var2, MobSpawnSettings.SpawnerData var3);

    public boolean removeSpawns(BiPredicate<MobCategory, MobSpawnSettings.SpawnerData> var1);

    default public boolean removeSpawnsOfEntityType(EntityType<?> entityType) {
        return this.removeSpawns((mobCategory, spawnerData) -> spawnerData.type() == entityType);
    }

    default public void clearSpawns(MobCategory mobCategory) {
        this.removeSpawns((mobCategoryX, spawnerData) -> mobCategoryX == mobCategory);
    }

    default public void clearSpawns() {
        this.removeSpawns((mobCategory, spawnerData) -> true);
    }

    public void setSpawnCost(EntityType<?> var1, double var2, double var4);

    public boolean clearSpawnCost(EntityType<?> var1);

    public Set<MobCategory> getMobCategoriesWithSpawns();

    public List<Weighted<MobSpawnSettings.SpawnerData>> getSpawnerData(MobCategory var1);

    public Set<EntityType<?>> getEntityTypesWithSpawnCost();

    @Nullable
    public MobSpawnSettings.MobSpawnCost getSpawnCost(EntityType<?> var1);

    public float getCreatureGenerationProbability();

    public void setCreatureGenerationProbability(float var1);
}

