/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.data.v2.models;

import fuzs.puzzleslib.api.client.data.v2.models.ModelLocationHelper;
import java.util.Optional;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public final class ModelTemplateHelper {
    private ModelTemplateHelper() {
    }

    public static ModelTemplate createBlockModelTemplate(ResourceLocation resourceLocation, TextureSlot ... requiredSlots) {
        return ModelTemplateHelper.createBlockModelTemplate(resourceLocation, "", requiredSlots);
    }

    public static ModelTemplate createBlockModelTemplate(ResourceLocation resourceLocation, String suffix, TextureSlot ... requiredSlots) {
        return new ModelTemplate(Optional.of(ModelLocationHelper.getBlockModel(resourceLocation)), Optional.of(suffix), requiredSlots);
    }

    public static ModelTemplate createItemModelTemplate(ResourceLocation resourceLocation, TextureSlot ... requiredSlots) {
        return ModelTemplateHelper.createItemModelTemplate(resourceLocation, "", requiredSlots);
    }

    public static ModelTemplate createItemModelTemplate(ResourceLocation resourceLocation, String suffix, TextureSlot ... requiredSlots) {
        return new ModelTemplate(Optional.of(ModelLocationHelper.getItemModel(resourceLocation)), Optional.of(suffix), requiredSlots);
    }

    public static TextureMapping createParticleTextureMapping(Block block) {
        return ModelTemplateHelper.createParticleTextureMapping(block, "");
    }

    public static TextureMapping createParticleTextureMapping(Block block, String suffix) {
        ResourceLocation resourceLocation = TextureMapping.getBlockTexture((Block)block, (String)suffix);
        return new TextureMapping().put(TextureSlot.TEXTURE, resourceLocation).put(TextureSlot.PARTICLE, resourceLocation);
    }

    public static TextureMapping createSingleSlotMapping(TextureSlot textureSlot, Block block) {
        return TextureMapping.singleSlot((TextureSlot)textureSlot, (ResourceLocation)TextureMapping.getBlockTexture((Block)block));
    }
}

