/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.searchtree.v1;

import fuzs.puzzleslib.api.client.searchtree.v1.SearchTreeType;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.SessionSearchTrees;
import net.minecraft.client.searchtree.SearchTree;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public final class SearchRegistryHelper {
    private static final Map<SearchTreeType<?>, Entry<?>> SEARCH_TREES = new IdentityHashMap();

    private SearchRegistryHelper() {
    }

    public static <T> void register(SearchTreeType<T> type, Function<List<T>, SearchTree<T>> factory) {
        SEARCH_TREES.put(type, new Entry<T>(factory));
    }

    public static Stream<String> getTooltipLines(ItemStack itemStack) {
        return SearchRegistryHelper.getTooltipLines(Stream.of(itemStack), (TooltipFlag)TooltipFlag.NORMAL);
    }

    public static Stream<String> getTooltipLines(Stream<ItemStack> stream, TooltipFlag tooltipFlag) {
        ClientPacketListener clientPacketListener = Minecraft.getInstance().getConnection();
        Objects.requireNonNull(clientPacketListener, "client packet listener is null");
        return SessionSearchTrees.getTooltipLines(stream, (Item.TooltipContext)Item.TooltipContext.of((HolderLookup.Provider)clientPacketListener.registryAccess()), (TooltipFlag)tooltipFlag);
    }

    public static <T> void populateSearchTree(SearchTreeType<T> type, List<T> values) {
        Entry<T> entry = SearchRegistryHelper.lookupEntry(type);
        ClientPacketListener clientPacketListener = Minecraft.getInstance().getConnection();
        Objects.requireNonNull(clientPacketListener, "client packet listener is null");
        clientPacketListener.searchTrees().register(entry.key, () -> {
            CompletableFuture searchTree = entry.searchTree;
            entry.searchTree = CompletableFuture.supplyAsync(() -> entry.factory.apply(values), (Executor)Util.backgroundExecutor());
            searchTree.cancel(true);
        });
    }

    public static <T> SearchTree<T> getSearchTree(SearchTreeType<T> type) {
        return SearchRegistryHelper.lookupEntry(type).searchTree.join();
    }

    private static <T> Entry<T> lookupEntry(SearchTreeType<T> type) {
        Entry<?> entry = SEARCH_TREES.get(type);
        Objects.requireNonNull(entry, () -> "Search tree type " + String.valueOf(type.resourceLocation()) + " is not registered");
        return entry;
    }

    private static class Entry<T> {
        public final SessionSearchTrees.Key key = new SessionSearchTrees.Key();
        public final Function<List<T>, SearchTree<T>> factory;
        public CompletableFuture<SearchTree<T>> searchTree = CompletableFuture.completedFuture(SearchTree.empty());

        Entry(Function<List<T>, SearchTree<T>> factory) {
            this.factory = factory;
        }
    }
}

