/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.data.v2;

import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import fuzs.puzzleslib.api.data.v2.core.RegistriesDataProvider;
import fuzs.puzzleslib.api.init.v3.registry.ResourceKeyHelper;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.data.PackOutput;
import net.minecraft.data.registries.RegistriesDatapackGenerator;
import net.minecraft.data.registries.RegistryPatchGenerator;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageEffects;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.item.equipment.trim.MaterialAssetGroup;
import net.minecraft.world.item.equipment.trim.TrimMaterial;

public abstract class AbstractDatapackRegistriesProvider
extends RegistriesDatapackGenerator
implements RegistriesDataProvider {
    private final CompletableFuture<HolderLookup.Provider> fullRegistries;

    public AbstractDatapackRegistriesProvider(DataProviderContext context) {
        this(context.getPackOutput(), context.getRegistries());
    }

    public AbstractDatapackRegistriesProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registries) {
        super(packOutput, CompletableFuture.completedFuture(RegistryAccess.EMPTY));
        CompletableFuture patchedRegistries = RegistryPatchGenerator.createLookup(registries, (RegistrySetBuilder)((RegistrySetBuilder)Util.make((Object)new RegistrySetBuilder(), registrySetBuilder -> this.addBootstrap((arg_0, arg_1) -> ((RegistrySetBuilder)registrySetBuilder).add(arg_0, arg_1)))));
        this.registries = patchedRegistries.thenApply(RegistrySetBuilder.PatchedRegistries::patches);
        this.fullRegistries = patchedRegistries.thenApply(RegistrySetBuilder.PatchedRegistries::full);
    }

    public abstract void addBootstrap(RegistryBoostrapConsumer var1);

    @Override
    public CompletableFuture<HolderLookup.Provider> getRegistries() {
        return this.fullRegistries;
    }

    public static void registerEnchantment(BootstrapContext<Enchantment> context, ResourceKey<Enchantment> resourceKey, Enchantment.Builder builder) {
        context.register(resourceKey, (Object)builder.build(resourceKey.location()));
    }

    public static void registerDamageType(BootstrapContext<DamageType> context, ResourceKey<DamageType> resourceKey) {
        context.register(resourceKey, (Object)new DamageType(resourceKey.location().getPath(), 0.1f));
    }

    public static void registerDamageType(BootstrapContext<DamageType> context, ResourceKey<DamageType> resourceKey, DamageEffects damageEffects) {
        context.register(resourceKey, (Object)new DamageType(resourceKey.location().getPath(), 0.1f, damageEffects));
    }

    public static void registerTrimMaterial(BootstrapContext<TrimMaterial> context, ResourceKey<TrimMaterial> resourceKey, Item ingredient, int descriptionColor) {
        AbstractDatapackRegistriesProvider.registerTrimMaterial(context, resourceKey, ingredient, descriptionColor, Collections.emptyMap());
    }

    public static void registerTrimMaterial(BootstrapContext<TrimMaterial> context, ResourceKey<TrimMaterial> resourceKey, Item ingredient, int descriptionColor, Map<ResourceKey<EquipmentAsset>, String> overrideArmorAssets) {
        MutableComponent component = ResourceKeyHelper.getComponent(resourceKey).withStyle(Style.EMPTY.withColor(descriptionColor));
        MaterialAssetGroup materialAssetGroup = MaterialAssetGroup.create((String)resourceKey.location().getPath(), overrideArmorAssets);
        TrimMaterial trimMaterial = new TrimMaterial(materialAssetGroup, (Component)component);
        context.register(resourceKey, (Object)trimMaterial);
    }

    public static void registerInstrument(BootstrapContext<Instrument> context, ResourceKey<Instrument> resourceKey, Holder<SoundEvent> soundEvent, float useDuration, float range) {
        context.register(resourceKey, (Object)new Instrument(soundEvent, useDuration, range, (Component)ResourceKeyHelper.getComponent(resourceKey)));
    }

    public static void registerJukeboxSong(BootstrapContext<JukeboxSong> context, ResourceKey<JukeboxSong> resourceKey, Holder<SoundEvent> soundEvent, float lengthInSeconds, int comparatorOutput) {
        context.register(resourceKey, (Object)new JukeboxSong(soundEvent, (Component)ResourceKeyHelper.getComponent(resourceKey), lengthInSeconds, comparatorOutput));
    }

    @FunctionalInterface
    public static interface RegistryBoostrapConsumer {
        public <T> void add(ResourceKey<? extends Registry<T>> var1, RegistrySetBuilder.RegistryBootstrap<T> var2);
    }
}

