/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.init.v3.registry;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelReader;

public final class LookupHelper {
    private LookupHelper() {
    }

    public static <T> Optional<Registry<T>> getRegistry(ResourceKey<? extends Registry<? super T>> registryKey) {
        Objects.requireNonNull(registryKey, "registry key is null");
        return BuiltInRegistries.REGISTRY.getOptional(registryKey);
    }

    public static <T> Holder<T> lookup(Entity entity, ResourceKey<? extends Registry<? extends T>> registryKey, ResourceKey<T> resourceKey) {
        Objects.requireNonNull(entity, "entity is null");
        return LookupHelper.lookup((HolderLookup.Provider)entity.registryAccess(), registryKey, resourceKey);
    }

    public static <T> Holder<T> lookup(LevelReader level, ResourceKey<? extends Registry<? extends T>> registryKey, ResourceKey<T> resourceKey) {
        Objects.requireNonNull(level, "level is null");
        return LookupHelper.lookup((HolderLookup.Provider)level.registryAccess(), registryKey, resourceKey);
    }

    public static <T> Holder<T> lookup(HolderLookup.Provider registries, ResourceKey<? extends Registry<? extends T>> registryKey, ResourceKey<T> resourceKey) {
        Objects.requireNonNull(registries, "registries is null");
        Objects.requireNonNull(registryKey, "registry key is null");
        Objects.requireNonNull(resourceKey, "resource key is null");
        return registries.lookupOrThrow(registryKey).getOrThrow(resourceKey);
    }
}

