/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.util.v1;

import fuzs.puzzleslib.impl.chat.StyleCombiningCharSink;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.util.StringDecomposer;

public final class ComponentHelper {
    private ComponentHelper() {
    }

    @Deprecated(forRemoval=true)
    public static Component toComponent(FormattedText formattedText) {
        return ComponentHelper.getAsComponent(formattedText);
    }

    @Deprecated(forRemoval=true)
    public static Component toComponent(FormattedCharSequence formattedCharSequence) {
        return ComponentHelper.getAsComponent(formattedCharSequence);
    }

    @Deprecated(forRemoval=true)
    public static String toString(FormattedText formattedText) {
        return ComponentHelper.getAsString(formattedText);
    }

    @Deprecated(forRemoval=true)
    public static String toString(FormattedCharSequence formattedCharSequence) {
        return ComponentHelper.getAsString(formattedCharSequence);
    }

    public static Component getAsComponent(String string) {
        Objects.requireNonNull(string, "string is null");
        return ComponentHelper.getAsComponent(FormattedText.of((String)string));
    }

    public static Component getAsComponent(FormattedText formattedText) {
        return (Component)ComponentHelper.iterate(formattedText, StyleCombiningCharSink::getAsComponent);
    }

    public static String getAsString(FormattedText formattedText) {
        return (String)ComponentHelper.iterate(formattedText, StyleCombiningCharSink::getAsString);
    }

    public static Component getAsComponent(FormattedCharSequence formattedCharSequence) {
        return (Component)ComponentHelper.iterate(formattedCharSequence, StyleCombiningCharSink::getAsComponent);
    }

    public static String getAsString(FormattedCharSequence formattedCharSequence) {
        return (String)ComponentHelper.iterate(formattedCharSequence, StyleCombiningCharSink::getAsString);
    }

    private static <T> T iterate(FormattedText formattedText, StyleCombiningCharSink.FormattedContentComposer<T> formattedContentComposer) {
        Objects.requireNonNull(formattedText, "formatted text is null");
        StyleCombiningCharSink styleCombiningCharSink = new StyleCombiningCharSink();
        StringDecomposer.iterateFormatted((FormattedText)formattedText, (Style)Style.EMPTY, (FormattedCharSink)styleCombiningCharSink);
        return (T)formattedContentComposer.apply(styleCombiningCharSink);
    }

    private static <T> T iterate(FormattedCharSequence formattedCharSequence, StyleCombiningCharSink.FormattedContentComposer<T> formattedContentComposer) {
        Objects.requireNonNull(formattedCharSequence, "formatted char sequence is null");
        StyleCombiningCharSink styleCombiningCharSink = new StyleCombiningCharSink();
        formattedCharSequence.accept((FormattedCharSink)styleCombiningCharSink);
        return ComponentHelper.iterate((FormattedText)styleCombiningCharSink.getAsComponent(), formattedContentComposer);
    }

    public static Style getDefaultStyle(String string) {
        Objects.requireNonNull(string, "string is null");
        Component component = ComponentHelper.getAsComponent(string);
        if (!string.isEmpty() && component.getString().isEmpty()) {
            int index = string.indexOf(ChatFormatting.RESET.toString());
            StringBuilder stringBuilder = new StringBuilder(string);
            stringBuilder.insert(index != -1 ? index : string.length(), " ");
            return ComponentHelper.getAsComponent(stringBuilder.toString()).getStyle();
        }
        return component.getStyle();
    }

    public static Style getDefaultStyle(FormattedText formattedText) {
        return ComponentHelper.getAsComponent(formattedText).getStyle();
    }

    public static Style getDefaultStyle(FormattedCharSequence formattedCharSequence) {
        return ComponentHelper.getAsComponent(formattedCharSequence).getStyle();
    }

    public static String getAsString(Style style) {
        Objects.requireNonNull(style, "style is null");
        if (style.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        ComponentHelper.getLegacyFormat(style, chatFormatting -> stringBuilder.append(chatFormatting.toString()));
        return stringBuilder.toString();
    }

    public static void getLegacyFormat(Style style, Consumer<ChatFormatting> chatFormattingConsumer) {
        ChatFormatting color;
        Objects.requireNonNull(style, "style is null");
        if (style.isEmpty()) {
            return;
        }
        if (style.getColor() != null && (color = ChatFormatting.getByName((String)style.getColor().serialize())) != null) {
            chatFormattingConsumer.accept(color);
        }
        if (style.isBold()) {
            chatFormattingConsumer.accept(ChatFormatting.BOLD);
        }
        if (style.isItalic()) {
            chatFormattingConsumer.accept(ChatFormatting.ITALIC);
        }
        if (style.isUnderlined()) {
            chatFormattingConsumer.accept(ChatFormatting.UNDERLINE);
        }
        if (style.isStrikethrough()) {
            chatFormattingConsumer.accept(ChatFormatting.STRIKETHROUGH);
        }
        if (style.isObfuscated()) {
            chatFormattingConsumer.accept(ChatFormatting.OBFUSCATED);
        }
    }

    public static Style sanitizeLegacyFormat(Style style) {
        Objects.requireNonNull(style, "style is null");
        if (style.isEmpty()) {
            return style;
        }
        if (!style.isBold()) {
            style = style.withBold(null);
        }
        if (!style.isItalic()) {
            style = style.withItalic(null);
        }
        if (!style.isUnderlined()) {
            style = style.withUnderlined(null);
        }
        if (!style.isStrikethrough()) {
            style = style.withStrikethrough(null);
        }
        if (!style.isObfuscated()) {
            style = style.withObfuscated(null);
        }
        return style;
    }
}

