/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.impl.item.TransmuteShapedRecipe;
import fuzs.puzzleslib.impl.item.TransmuteShapelessRecipe;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;

public interface CustomTransmuteRecipe {
    public static final String TRANSMUTE_SHAPED_RECIPE_SERIALIZER_ID = "crafting_transmute_shaped";
    public static final String TRANSMUTE_SHAPELESS_RECIPE_SERIALIZER_ID = "crafting_transmute_shapeless";

    public static RecipeSerializer<?> getModSerializer(String modId, String recipeSerializerId) {
        RecipeSerializer recipeSerializer = (RecipeSerializer)BuiltInRegistries.RECIPE_SERIALIZER.getValue(ResourceLocationHelper.fromNamespaceAndPath(modId, recipeSerializerId));
        Objects.requireNonNull(recipeSerializer, "recipe serializer '" + String.valueOf(ResourceLocationHelper.fromNamespaceAndPath(modId, recipeSerializerId)) + "' not registered");
        return recipeSerializer;
    }

    public static void registerSerializers(BiConsumer<String, Supplier<RecipeSerializer<?>>> registrar) {
        registrar.accept(TRANSMUTE_SHAPED_RECIPE_SERIALIZER_ID, () -> new Serializer<ShapedRecipe, TransmuteShapedRecipe>((RecipeSerializer<ShapedRecipe>)new ShapedRecipe.Serializer(), TransmuteShapedRecipe::new));
        registrar.accept(TRANSMUTE_SHAPELESS_RECIPE_SERIALIZER_ID, () -> new Serializer<ShapelessRecipe, TransmuteShapelessRecipe>((RecipeSerializer<ShapelessRecipe>)new ShapelessRecipe.Serializer(), TransmuteShapelessRecipe::new));
    }

    public Ingredient getInput();

    default public void transmuteInput(ItemStack result, CraftingInput craftingInput) {
        for (int i = 0; i < craftingInput.size(); ++i) {
            ItemStack itemStack = craftingInput.getItem(i);
            if (!this.getInput().test(itemStack)) continue;
            result.applyComponents(itemStack.getComponentsPatch());
            return;
        }
    }

    public record Serializer<R1 extends CraftingRecipe, R2 extends CraftingRecipe & CustomTransmuteRecipe>(RecipeSerializer<R1> serializer, Factory<R1, R2> factory) implements RecipeSerializer<R2>
    {
        public MapCodec<R2> codec() {
            return RecordCodecBuilder.mapCodec(instance -> instance.group((App)this.serializer.codec().forGetter(arg -> arg), (App)Ingredient.CODEC.fieldOf("input").forGetter(rec$ -> ((CustomTransmuteRecipe)rec$).getInput())).apply((Applicative)instance, (craftingRecipe, ingredient) -> this.factory.apply(this, (R1)craftingRecipe, (Ingredient)ingredient)));
        }

        public StreamCodec<RegistryFriendlyByteBuf, R2> streamCodec() {
            return StreamCodec.of((x$0, x$1) -> this.toNetwork((RegistryFriendlyByteBuf)x$0, (Object)((CraftingRecipe)x$1)), this::fromNetwork);
        }

        private R2 fromNetwork(RegistryFriendlyByteBuf buffer) {
            CraftingRecipe recipe = (CraftingRecipe)this.serializer.streamCodec().decode((Object)buffer);
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            return this.factory.apply(this, recipe, ingredient);
        }

        private void toNetwork(RegistryFriendlyByteBuf buffer, R2 recipe) {
            this.serializer.streamCodec().encode((Object)buffer, recipe);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)((CustomTransmuteRecipe)recipe).getInput());
        }
    }

    @FunctionalInterface
    public static interface Factory<T extends CraftingRecipe, S extends CraftingRecipe & CustomTransmuteRecipe> {
        public S apply(RecipeSerializer<?> var1, T var2, Ingredient var3);
    }
}

