/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.neoforge.impl.core;

import com.google.common.collect.ImmutableMap;
import fuzs.puzzleslib.api.core.v1.ModContainer;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.neoforged.fml.ModList;
import net.neoforged.fml.i18n.MavenVersionTranslator;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.moddiscovery.ModFileInfo;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.language.IModInfo;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.jetbrains.annotations.Nullable;

public final class NeoForgeModContainer
implements ModContainer {
    private final IModInfo metadata;
    private final List<ModContainer> children;
    @Nullable
    private ModContainer parent;

    public NeoForgeModContainer(IModInfo metadata) {
        this.metadata = metadata;
        this.children = new ArrayList<ModContainer>();
    }

    @Override
    public String getModId() {
        return this.metadata.getModId();
    }

    @Override
    public String getDisplayName() {
        return this.metadata.getDisplayName();
    }

    @Override
    public String getDescription() {
        return this.metadata.getDescription();
    }

    @Override
    public String getVersion() {
        return MavenVersionTranslator.artifactVersionToString((ArtifactVersion)this.metadata.getVersion());
    }

    @Override
    public Collection<String> getLicenses() {
        return List.of(this.metadata.getOwningFile().getLicense());
    }

    @Override
    public Collection<String> getAuthors() {
        return this.getConfigElement("authors");
    }

    @Override
    public Collection<String> getCredits() {
        return this.getConfigElement("credits");
    }

    private List<String> getConfigElement(String configKey) {
        return this.metadata.getConfig().getConfigElement(new String[]{configKey}).map(authors -> {
            if (authors instanceof Collection) {
                Collection collection = (Collection)authors;
                return collection.stream().map(Object::toString).toList();
            }
            return List.of(authors.toString());
        }).orElseGet(List::of);
    }

    @Override
    public Map<String, String> getContactTypes() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.metadata.getConfig().getConfigElement(new String[]{"displayURL"}).or(() -> this.metadata.getModURL().map(URL::toString)).ifPresent(s -> builder.put((Object)"homepage", s));
        IModFileInfo iModFileInfo = this.metadata.getOwningFile();
        if (iModFileInfo instanceof ModFileInfo) {
            ModFileInfo modFileInfo = (ModFileInfo)iModFileInfo;
            Optional.ofNullable(modFileInfo.getIssueURL()).map(URL::toString).ifPresent(s -> builder.put((Object)"issues", s));
        }
        return builder.build();
    }

    @Override
    public Optional<Path> findResource(String ... path) {
        return Optional.of(this.metadata.getOwningFile().getFile().findResource(path)).filter(x$0 -> Files.exists(x$0, new LinkOption[0]));
    }

    @Override
    public Collection<ModContainer> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    @Nullable
    public ModContainer getParent() {
        return this.parent;
    }

    public void setParent(@Nullable NeoForgeModContainer parent) {
        if (parent != null && parent != this) {
            this.parent = parent;
            parent.addChild(this);
        }
    }

    private void addChild(ModContainer modContainer) {
        Objects.requireNonNull(modContainer, "child is null");
        if (!this.children.contains(modContainer)) {
            this.children.add(modContainer);
            this.children.sort(Comparator.comparing(ModContainer::getModId));
        }
    }

    public URI getURI() {
        return this.metadata.getOwningFile().getFile().getSecureJar().moduleDataProvider().uri();
    }

    public static Stream<? extends ModContainer> getNeoForgeModContainers() {
        Map allMods = NeoForgeModContainer.getNeoForgeModList().stream().map(NeoForgeModContainer::new).collect(Collectors.toMap(modContainer -> modContainer.getURI().getSchemeSpecificPart(), Function.identity(), (o1, o2) -> {
            o2.setParent((NeoForgeModContainer)o1);
            return o1;
        }));
        for (NeoForgeModContainer modContainer2 : allMods.values()) {
            if (!modContainer2.getURI().getScheme().equals("union")) continue;
            String schemePart = NeoForgeModContainer.getParentSchemePart(modContainer2.getURI().getSchemeSpecificPart());
            modContainer2.setParent((NeoForgeModContainer)allMods.get(schemePart));
        }
        return allMods.values().stream();
    }

    private static List<? extends IModInfo> getNeoForgeModList() {
        if (ModList.get() != null) {
            return ModList.get().getMods();
        }
        if (FMLLoader.getLoadingModList() != null) {
            return FMLLoader.getLoadingModList().getMods();
        }
        throw new NullPointerException("mod list is null");
    }

    private static String getParentSchemePart(String schemePart) {
        return schemePart.replace("/jij:file:///", "file:///").replaceAll("_/META-INF/.+(#|%23)\\d+!/$", "!/");
    }
}

