/*
 * Decompiled with CFR 0.152.
 */
package team.creative.playerrevive.packet;

import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueOutput;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.playerrevive.api.IBleeding;
import team.creative.playerrevive.server.PlayerReviveServer;

public class ReviveUpdatePacket
extends CreativePacket {
    public UUID uuid;
    public CompoundTag nbt;

    public ReviveUpdatePacket(Player player) {
        TagValueOutput output = TagValueOutput.createWithContext((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)player.registryAccess());
        PlayerReviveServer.getBleeding(player).serialize((ValueOutput)output);
        this.nbt = output.buildResult();
        this.uuid = player.getUUID();
    }

    public ReviveUpdatePacket() {
    }

    public void executeClient(Player player) {
        Player member = Minecraft.getInstance().level.getPlayerByUUID(this.uuid);
        if (member != null) {
            IBleeding bleeding = PlayerReviveServer.getBleeding(member);
            bleeding.deserialize(TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)player.registryAccess(), (CompoundTag)this.nbt));
            if (!bleeding.isBleeding()) {
                member.setPose(Pose.STANDING);
            }
        }
    }

    public void executeServer(ServerPlayer player) {
    }
}

