/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.ingredient;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ItemMatch;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.ingredient.IngredientHelpers;
import org.cyclops.cyclopscore.helper.IModHelpers;

public class IngredientMatcherItemStack
implements IIngredientMatcher<ItemStack, Integer> {
    @Override
    public boolean isInstance(Object object) {
        return object instanceof ItemStack;
    }

    @Override
    public Integer getAnyMatchCondition() {
        return 0;
    }

    @Override
    public Integer getExactMatchCondition() {
        return 13;
    }

    @Override
    public Integer getExactMatchNoQuantityCondition() {
        return 5;
    }

    @Override
    public Integer withCondition(Integer matchCondition, Integer with) {
        return matchCondition | with;
    }

    @Override
    public Integer withoutCondition(Integer matchCondition, Integer without) {
        return matchCondition & ~without.intValue();
    }

    @Override
    public boolean hasCondition(Integer matchCondition, Integer searchCondition) {
        return (matchCondition & searchCondition) > 0;
    }

    @Override
    public boolean matches(ItemStack a, ItemStack b, Integer matchCondition) {
        return ItemMatch.areItemStacksEqual(a, b, matchCondition);
    }

    @Override
    public ItemStack getEmptyInstance() {
        return ItemStack.EMPTY;
    }

    @Override
    public boolean isEmpty(ItemStack instance) {
        return instance.isEmpty();
    }

    @Override
    public int hash(ItemStack instance) {
        return IModHelpers.get().getItemStackHelpers().getItemStackHashCode(instance);
    }

    @Override
    public ItemStack copy(ItemStack instance) {
        return instance.copy();
    }

    @Override
    public long getQuantity(ItemStack instance) {
        return instance.getCount();
    }

    @Override
    public ItemStack withQuantity(ItemStack instance, long quantity) {
        if ((long)instance.getCount() == quantity) {
            return instance;
        }
        ItemStack copy = instance.copy();
        copy.setCount(IModHelpers.get().getBaseHelpers().castSafe(quantity));
        return copy;
    }

    @Override
    public long getMaximumQuantity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int conditionCompare(Integer a, Integer b) {
        return Integer.compare(a, b);
    }

    @Override
    public String localize(ItemStack instance) {
        return instance.getHoverName().getString();
    }

    @Override
    public MutableComponent getDisplayName(ItemStack instance) {
        return (MutableComponent)instance.getHoverName();
    }

    @Override
    public String toString(ItemStack instance) {
        return String.format("%s %s %s", BuiltInRegistries.ITEM.getKey((Object)instance.getItem()), instance.getCount(), instance.getComponents());
    }

    @Override
    public int compare(ItemStack o1, ItemStack o2) {
        if (o1.isEmpty()) {
            if (o2.isEmpty()) {
                return 0;
            }
            return -1;
        }
        if (o2.isEmpty()) {
            return 1;
        }
        if (o1.getItem() == o2.getItem()) {
            int c2;
            int c1 = o1.getCount();
            if (c1 == (c2 = o2.getCount())) {
                return IngredientHelpers.compareData(o1.getComponents(), o2.getComponents());
            }
            return c1 - c2;
        }
        return Item.getId((Item)o1.getItem()) - Item.getId((Item)o2.getItem());
    }
}

