/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easymagic.client;

import fuzs.easymagic.EasyMagic;
import fuzs.easymagic.client.gui.screens.inventory.ModEnchantmentScreen;
import fuzs.easymagic.client.handler.BlockStateTranslator;
import fuzs.easymagic.client.handler.ChiseledBookshelfTooltipHandler;
import fuzs.easymagic.client.renderer.blockentity.ModEnchantTableRenderer;
import fuzs.easymagic.handler.BlockConversionHandler;
import fuzs.easymagic.init.ModRegistry;
import fuzs.puzzleslib.api.client.core.v1.ClientModConstructor;
import fuzs.puzzleslib.api.client.core.v1.context.BlockEntityRenderersContext;
import fuzs.puzzleslib.api.client.core.v1.context.BlockStateResolverContext;
import fuzs.puzzleslib.api.client.core.v1.context.GuiLayersContext;
import fuzs.puzzleslib.api.client.core.v1.context.MenuScreensContext;
import fuzs.puzzleslib.api.client.core.v1.context.RenderTypesContext;
import fuzs.puzzleslib.api.client.event.v1.gui.RenderTooltipCallback;
import fuzs.puzzleslib.api.client.renderer.v1.model.ModelLoadingHelper;
import java.util.Map;
import java.util.concurrent.Executor;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class EasyMagicClient
implements ClientModConstructor {
    public void onConstructMod() {
        EasyMagicClient.registerEventHandlers();
    }

    private static void registerEventHandlers() {
        RenderTooltipCallback.EVENT.register(ModEnchantmentScreen::onRenderTooltip);
    }

    public void onRegisterBlockStateResolver(BlockStateResolverContext context) {
        BlockConversionHandler.getBlockConversions().forEach((oldBlock, newBlock) -> context.registerBlockStateResolver(newBlock, (resourceManager, executor) -> ModelLoadingHelper.loadBlockState((ResourceManager)resourceManager, (Block)oldBlock, (Executor)executor), (loadedModels, blockStateConsumer) -> {
            Map<BlockState, BlockState> blockStates = BlockStateTranslator.INSTANCE.convertAllBlockStates((Block)newBlock, (Block)oldBlock);
            for (BlockState blockState : newBlock.getStateDefinition().getPossibleStates()) {
                BlockStateModel.UnbakedRoot model = (BlockStateModel.UnbakedRoot)loadedModels.models().get(blockStates.get(blockState));
                if (model != null) {
                    blockStateConsumer.accept(blockState, model);
                    continue;
                }
                EasyMagic.LOGGER.warn("Missing model for variant: '{}'", (Object)blockState);
                blockStateConsumer.accept(blockState, ModelLoadingHelper.missingModel());
            }
        }));
    }

    public void onRegisterMenuScreens(MenuScreensContext context) {
        context.registerMenuScreen((MenuType)ModRegistry.ENCHANTING_MENU_TYPE.value(), ModEnchantmentScreen::new);
    }

    public void onRegisterBlockEntityRenderers(BlockEntityRenderersContext context) {
        context.registerBlockEntityRenderer((BlockEntityType)ModRegistry.ENCHANTING_TABLE_BLOCK_ENTITY_TYPE.value(), ModEnchantTableRenderer::new);
    }

    public void onRegisterBlockRenderTypes(RenderTypesContext<Block> context) {
        for (Map.Entry entry : BlockConversionHandler.getBlockConversions().entrySet()) {
            context.registerChunkRenderType((Object)((Block)entry.getValue()), context.getChunkRenderType((Object)((Block)entry.getKey())));
        }
    }

    public void onRegisterGuiLayers(GuiLayersContext context) {
        context.registerGuiLayer(GuiLayersContext.HELD_ITEM_TOOLTIP, EasyMagic.id("chiseled_bookshelf_tooltip"), ChiseledBookshelfTooltipHandler::render);
    }
}

