/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easymagic.client.handler;

import fuzs.easymagic.EasyMagic;
import fuzs.easymagic.config.ClientConfig;
import fuzs.easymagic.mixin.client.accessor.ChiseledBookShelfBlockAccessor;
import fuzs.puzzleslib.api.client.gui.v2.tooltip.TooltipRenderHelper;
import java.util.List;
import java.util.OptionalInt;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChiseledBookShelfBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class ChiseledBookshelfTooltipHandler {
    public static void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        ChiseledBookShelfBlockEntity blockEntity;
        ItemStack itemStack;
        BlockEntity blockEntity2;
        BooleanProperty property;
        OptionalInt hitSlot;
        Minecraft minecraft = Minecraft.getInstance();
        if (!ChiseledBookshelfTooltipHandler.canRenderTooltip(minecraft)) {
            return;
        }
        BlockHitResult hitResult = (BlockHitResult)minecraft.hitResult;
        BlockState blockState = minecraft.level.getBlockState(hitResult.getBlockPos());
        if (blockState.getBlock() instanceof ChiseledBookShelfBlock && (hitSlot = ((ChiseledBookShelfBlockAccessor)blockState.getBlock()).easymagic$callGetHitSlot(hitResult, blockState)).isPresent() && ((Boolean)blockState.getValue((Property)(property = (BooleanProperty)ChiseledBookShelfBlock.SLOT_OCCUPIED_PROPERTIES.get(hitSlot.getAsInt())))).booleanValue() && (blockEntity2 = minecraft.level.getBlockEntity(hitResult.getBlockPos())) instanceof ChiseledBookShelfBlockEntity && !(itemStack = (blockEntity = (ChiseledBookShelfBlockEntity)blockEntity2).getItem(hitSlot.getAsInt())).isEmpty()) {
            ChiseledBookshelfTooltipHandler.renderBookTooltip(guiGraphics, guiGraphics.guiWidth(), guiGraphics.guiHeight(), itemStack, minecraft.font);
        }
    }

    private static boolean canRenderTooltip(Minecraft minecraft) {
        Entity entity;
        if (((ClientConfig)EasyMagic.CONFIG.get(ClientConfig.class)).chiseledBookshelfTooltip == ClientConfig.ChiseledBookshelfTooltip.DISABLED) {
            return false;
        }
        if (!minecraft.options.hideGui && minecraft.options.getCameraType().isFirstPerson() && minecraft.gameMode != null && minecraft.gameMode.getPlayerMode() != GameType.SPECTATOR && (entity = minecraft.cameraEntity) instanceof Player) {
            Player player = (Player)entity;
            if (minecraft.hitResult != null && minecraft.hitResult.getType() == HitResult.Type.BLOCK) {
                return player.isShiftKeyDown() || ((ClientConfig)EasyMagic.CONFIG.get(ClientConfig.class)).chiseledBookshelfTooltip == ClientConfig.ChiseledBookshelfTooltip.ENABLED;
            }
        }
        return false;
    }

    private static void renderBookTooltip(GuiGraphics guiGraphics, int screenWidth, int screenHeight, ItemStack itemStack, Font font) {
        List components = TooltipRenderHelper.getTooltip((ItemStack)itemStack, (TooltipFlag)TooltipFlag.NORMAL);
        int posX = screenWidth / 2 - 12 + 22 + ((ClientConfig)EasyMagic.CONFIG.get(ClientConfig.class)).chiseledBookshelfTooltipOffsetX;
        int posY = screenHeight / 2 + 12 - ChiseledBookshelfTooltipHandler.getFullTooltipHeight(components, font) / 2 + ((ClientConfig)EasyMagic.CONFIG.get(ClientConfig.class)).chiseledBookshelfTooltipOffsetY;
        TooltipRenderHelper.renderTooltipComponents((GuiGraphics)guiGraphics, (int)posX, (int)posY, (List)components, null);
    }

    private static int getFullTooltipHeight(List<ClientTooltipComponent> components, Font font) {
        int height = components.size() == 1 ? -2 : 0;
        return height += components.stream().mapToInt(component -> component.getHeight(font)).sum();
    }
}

