/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easymagic.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fuzs.easymagic.EasyMagic;
import fuzs.easymagic.config.ClientConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.EnchantTableRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.EnchantingTableBlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class ModEnchantTableRenderer
extends EnchantTableRenderer {
    private final ItemStackRenderState itemStackRenderState = new ItemStackRenderState();
    public final ItemModelResolver itemModelResolver;
    public final ItemRenderer itemRenderer;

    public ModEnchantTableRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
        this.itemRenderer = context.getItemRenderer();
        this.itemModelResolver = context.getItemModelResolver();
    }

    public void render(EnchantingTableBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, Vec3 cameraPosition) {
        super.render(blockEntity, partialTick, poseStack, bufferSource, packedLight, packedOverlay, cameraPosition);
        Level level = blockEntity.getLevel();
        if (level != null) {
            ItemStack itemStack = ((Container)blockEntity).getItem(0);
            ItemStack enchantingCatalystItemStack = ((Container)blockEntity).getItem(1);
            ItemStack rerollCatalystItemStack = ((Container)blockEntity).getItem(2);
            int posData = (int)blockEntity.getBlockPos().asLong();
            switch (((ClientConfig)EasyMagic.CONFIG.get(ClientConfig.class)).renderEnchantingTableContents) {
                case FLAT: {
                    List<ItemStack> itemStacks = ModEnchantTableRenderer.collectItemStacks(itemStack, enchantingCatalystItemStack, rerollCatalystItemStack);
                    this.renderFlatItemList(itemStacks, blockEntity.getBlockPos(), poseStack, bufferSource, packedLight, packedOverlay, level, posData);
                    break;
                }
                case FLOATING: {
                    List<ItemStack> itemStacks = ModEnchantTableRenderer.collectItemStacks(ItemStack.EMPTY, enchantingCatalystItemStack, rerollCatalystItemStack);
                    this.renderHoveringItem(blockEntity, itemStack, partialTick, poseStack, bufferSource, packedLight, packedOverlay);
                    this.renderHoveringItemList(itemStacks, (float)blockEntity.time + partialTick, poseStack, bufferSource, packedLight, packedOverlay, true, level, posData);
                }
            }
        }
    }

    private static List<ItemStack> collectItemStacks(ItemStack itemStack, ItemStack enchantingCatalystItemStack, ItemStack rerollCatalystItemStack) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        itemStacks.add(itemStack);
        for (int i = 0; i < 3; ++i) {
            if (i < enchantingCatalystItemStack.getCount()) {
                itemStacks.add(enchantingCatalystItemStack);
            }
            if (i >= rerollCatalystItemStack.getCount()) continue;
            itemStacks.add(rerollCatalystItemStack);
        }
        itemStacks.removeIf(ItemStack::isEmpty);
        return itemStacks;
    }

    private void renderFlatItemList(List<ItemStack> itemStacks, BlockPos blockPos, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, Level level, int posData) {
        int randomDirection = Math.abs(blockPos.getX() + blockPos.getZ()) % 4;
        for (int i = 0; i < Math.min(4, itemStacks.size()); ++i) {
            poseStack.pushPose();
            poseStack.translate(0.5, 0.76171875, 0.5);
            Direction direction = Direction.from2DDataValue((int)((i + randomDirection) % 4));
            float horizontalAngle = -direction.toYRot();
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(horizontalAngle));
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
            poseStack.translate(-0.3125, -0.3125, 0.0);
            poseStack.scale(0.375f, 0.375f, 0.375f);
            ItemStack renderStack = itemStacks.get(i);
            this.itemRenderer.renderStatic(renderStack, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, bufferSource, level, posData + i);
            poseStack.popPose();
        }
    }

    private void renderHoveringItem(EnchantingTableBlockEntity blockEntity, ItemStack itemStack, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (blockEntity.open != 0.0f || blockEntity.oOpen != 0.0f) {
            this.itemModelResolver.updateForTopItem(this.itemStackRenderState, itemStack, ItemDisplayContext.GROUND, blockEntity.getLevel(), null, 0);
            poseStack.pushPose();
            poseStack.translate(0.5f, 1.0f, 0.5f);
            float hoverOffset = Mth.sin((float)(((float)blockEntity.time + partialTick) / 10.0f)) * 0.1f + 0.1f;
            AABB aABB = this.itemStackRenderState.getModelBoundingBox();
            float modelYScale = -((float)aABB.minY) + 0.0625f;
            float openness = Mth.lerp((float)partialTick, (float)blockEntity.oOpen, (float)blockEntity.open);
            poseStack.translate(0.0, (double)(hoverOffset + modelYScale * openness - 0.15f * (1.0f - openness)), 0.0);
            float scale = openness * 0.8f + 0.2f;
            poseStack.scale(scale, scale, scale);
            poseStack.mulPose((Quaternionfc)Axis.YP.rotation(((float)blockEntity.time + partialTick) / 20.0f));
            this.itemStackRenderState.render(poseStack, bufferSource, packedLight, packedOverlay);
            poseStack.popPose();
        }
    }

    private void renderHoveringItemList(List<ItemStack> itemStacks, float age, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, boolean rotateItems, Level level, int posData) {
        float itemRenderAngle = 360.0f / (float)itemStacks.size();
        for (int i = 0; i < itemStacks.size(); ++i) {
            poseStack.pushPose();
            poseStack.translate(0.5f, 1.0f, 0.5f);
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)i * itemRenderAngle + age));
            poseStack.translate(0.75f, 0.0f, 0.25f);
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(rotateItems ? age % 360.0f : 90.0f));
            poseStack.translate(0.0, 0.075 * Math.sin(((double)age + (double)i * 10.0) / 5.0), 0.0);
            this.itemRenderer.renderStatic(itemStacks.get(i), ItemDisplayContext.GROUND, packedLight, packedOverlay, poseStack, bufferSource, level, posData + i);
            poseStack.popPose();
        }
    }
}

