/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easymagic.world.level.block.entity;

import fuzs.easymagic.EasyMagic;
import fuzs.easymagic.config.ServerConfig;
import fuzs.easymagic.init.ModRegistry;
import fuzs.easymagic.world.inventory.ModEnchantmentMenu;
import fuzs.puzzleslib.api.block.v1.entity.TickingBlockEntity;
import fuzs.puzzleslib.api.container.v1.ListBackedContainer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.LockCode;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.EnchantingTableBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;

public class EnchantmentTableWithInventoryBlockEntity
extends EnchantingTableBlockEntity
implements ListBackedContainer,
MenuProvider,
WorldlyContainer,
TickingBlockEntity {
    private final NonNullList<ItemStack> items = NonNullList.withSize((int)3, (Object)ItemStack.EMPTY);
    private LockCode code = LockCode.NO_LOCK;

    public EnchantmentTableWithInventoryBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(blockPos, blockState);
    }

    public BlockEntityType<?> getType() {
        return (BlockEntityType)ModRegistry.ENCHANTING_TABLE_BLOCK_ENTITY_TYPE.value();
    }

    public void loadAdditional(ValueInput compoundTag) {
        super.loadAdditional(compoundTag);
        this.code = LockCode.fromTag((ValueInput)compoundTag);
        this.items.clear();
        ContainerHelper.loadAllItems((ValueInput)compoundTag, this.items);
    }

    protected void saveAdditional(ValueOutput compoundTag) {
        super.saveAdditional(compoundTag);
        this.code.addToTag(compoundTag);
        ContainerHelper.saveAllItems((ValueOutput)compoundTag, this.items, (boolean)true);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public NonNullList<ItemStack> getContainerItems() {
        return this.items;
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public boolean stillValid(Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    public boolean canPlaceItem(int index, ItemStack itemStack) {
        if (index == 2) {
            return itemStack.is(ModRegistry.REROLL_CATALYSTS_ITEM_TAG);
        }
        if (index == 1) {
            return itemStack.is(ModRegistry.ENCHANTING_CATALYSTS_ITEM_TAG);
        }
        if (index == 0) {
            return ((ItemStack)this.items.get(0)).isEmpty();
        }
        return false;
    }

    public int[] getSlotsForFace(Direction direction) {
        if (direction.getAxis().isHorizontal()) {
            int[] nArray;
            if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).dedicatedRerollCatalyst()) {
                int[] nArray2 = new int[2];
                nArray2[0] = 1;
                nArray = nArray2;
                nArray2[1] = 2;
            } else {
                int[] nArray3 = new int[1];
                nArray = nArray3;
                nArray3[0] = 1;
            }
            return nArray;
        }
        return new int[]{0};
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack itemStack, @Nullable Direction direction) {
        return this.canPlaceItem(index, itemStack);
    }

    public boolean canTakeItemThroughFace(int index, ItemStack itemStack, Direction direction) {
        return index == 0 && (itemStack.isEnchanted() || itemStack.is(Items.ENCHANTED_BOOK));
    }

    public Component getDisplayName() {
        return this.getName();
    }

    public boolean canOpen(Player player) {
        return BaseContainerBlockEntity.canUnlock((Player)player, (LockCode)this.code, (Component)this.getDisplayName());
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player player) {
        return this.canOpen(player) ? this.createMenu(id, playerInventory) : null;
    }

    protected AbstractContainerMenu createMenu(int id, Inventory playerInventory) {
        return new ModEnchantmentMenu(id, playerInventory, (Container)this, ContainerLevelAccess.create((Level)this.level, (BlockPos)this.worldPosition));
    }

    public void clientTick() {
        EnchantmentTableWithInventoryBlockEntity.bookAnimationTick((Level)this.getLevel(), (BlockPos)this.getBlockPos(), (BlockState)this.getBlockState(), (EnchantingTableBlockEntity)this);
    }
}

