/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.client;

import com.endertech.common.Args;
import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.blocks.IEmitter;
import com.endertech.minecraft.forge.client.GameKeys;
import com.endertech.minecraft.forge.data.TagHelper;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.items.ForgeItem;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.BiomeId;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.IWind;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import org.joml.Matrix3x2fStack;

@EventBusSubscriber(modid="forgeendertech", value={Dist.CLIENT})
public class DevInfo {
    public static DevInfo INSTANCE = new DevInfo();
    static final GameTime UPDATE_INTERVAL = GameTime.quaterSecond();
    static final GameTime EXCEPTION_PRINT_INTERVAL = GameTime.seconds(10);
    protected static float rayTraceDistance = 10.0f;
    protected static boolean showInventoryTooltip = false;
    protected static boolean renderGameOverlay = false;
    protected static boolean hotKeyWasDown = false;
    private static HitResult rayTraceResult = null;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRender(ScreenEvent.Render.Post event) {
        if (renderGameOverlay) {
            INSTANCE.render(event.getGuiGraphics(), event.getPartialTick());
        }
    }

    @SubscribeEvent
    public static void onKeyPressed(InputEvent.Key event) {
        if (ForgeEndertech.isDebugMode() && Minecraft.getInstance().level != null) {
            int hotKey = 281;
            if (GameKeys.isDown(281)) {
                if (!hotKeyWasDown && GameKeys.isShiftDown()) {
                    showInventoryTooltip = !showInventoryTooltip;
                    renderGameOverlay = !renderGameOverlay;
                }
                hotKeyWasDown = true;
            } else {
                hotKeyWasDown = false;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onInventoryTooltip(ItemTooltipEvent event) {
        if (!showInventoryTooltip) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (!stack.isEmpty()) {
            List lines = event.getToolTip();
            Optional.ofNullable(event.getEntity()).map(Entity::level).ifPresent(level -> DevInfo.addItemInfo(level, stack, lines));
        }
    }

    private DevInfo() {
    }

    public void render(GuiGraphics guiGraphics, float partialTick) {
        block10: {
            Minecraft mc = Minecraft.getInstance();
            Matrix3x2fStack pose = guiGraphics.pose();
            if (mc.level == null || mc.player == null) {
                return;
            }
            try {
                boolean shouldRecalcTraceResult;
                ArrayList<Component> lines = new ArrayList<Component>();
                DevInfo.addWorldInfo(mc.level, lines);
                lines.add((Component)Component.literal((String)""));
                boolean bl = shouldRecalcTraceResult = rayTraceResult == null || UPDATE_INTERVAL.pastIn((Level)mc.level);
                if (shouldRecalcTraceResult) {
                    rayTraceResult = mc.options.keySprint.isDown() ? mc.hitResult : (HitResult)ForgeEntity.rayTraceBlockBeingLookedAt((Entity)mc.player, ClipContext.Block.VISUAL, ClipContext.Fluid.ANY, partialTick, rayTraceDistance).orElse(null);
                }
                if (rayTraceResult != null) {
                    switch (rayTraceResult.getType()) {
                        case BLOCK: {
                            if (!(rayTraceResult instanceof BlockHitResult)) break;
                            DevInfo.addBlockInfo(mc.level, ((BlockHitResult)rayTraceResult).getBlockPos(), lines);
                            break;
                        }
                        case ENTITY: {
                            if (!(rayTraceResult instanceof EntityHitResult)) break;
                            DevInfo.addEntityInfo(((EntityHitResult)rayTraceResult).getEntity(), lines);
                            break;
                        }
                    }
                }
                pose.pushMatrix();
                int color = -2130706433;
                int x = 2;
                int y = 2;
                int step = 10;
                for (Component line : lines) {
                    guiGraphics.drawString(mc.font, line.getString(), x, y, color);
                    y += step;
                }
                pose.popMatrix();
            }
            catch (Exception e) {
                if (!EXCEPTION_PRINT_INTERVAL.pastIn((Level)mc.level)) break block10;
                ForgeEndertech.debugMsg(e.toString());
            }
        }
    }

    protected static void addCaptionLine(List<Component> lines, String caption) {
        lines.add((Component)Component.literal((String)("==" + caption + "==")));
    }

    protected static void addInfoLine(List<Component> lines, String caption, Object value) {
        lines.add((Component)DevInfo.caption(caption).append(String.valueOf(value)));
    }

    protected static void addWorldInfo(ClientLevel level, List<Component> lines) {
        LocalPlayer player = Minecraft.getInstance().player;
        BlockPos pos = player.blockPosition();
        BiomeId biome = BiomeId.from((LevelAccessor)level, pos);
        GameWorld.WorldData data = GameWorld.getData((LevelAccessor)level);
        IWind wind = GameWorld.getWindAt((Level)level, pos);
        DevInfo.addCaptionLine(lines, "World Info");
        DevInfo.addInfoLine(lines, "Biome", biome.toString());
        DevInfo.addInfoLine(lines, "Wind", Float.valueOf(wind.getStrengthIn(player.getDirection())));
        DevInfo.addInfoLine(lines, "isRaining", level.isRaining());
        DevInfo.addInfoLine(lines, "Level", "rain = " + level.rainLevel + ", thunder = " + level.thunderLevel);
        DevInfo.addInfoLine(lines, "SmokeParticles", data.smokeParticlesCount);
        DevInfo.addInfoLine(lines, "GameTime", level.getGameTime());
    }

    protected static void addBlockInfo(ClientLevel level, BlockPos pos, List<Component> lines) {
        BlockState state = level.getBlockState(pos);
        UnitId id = UnitId.from(state);
        DevInfo.addCaptionLine(lines, "Block Info");
        lines.add((Component)DevInfo.formatedId(id));
        DevInfo.addInfoLine(lines, "State", state);
        if (rayTraceResult instanceof BlockHitResult) {
            Direction face = ((BlockHitResult)rayTraceResult).getDirection();
            boolean solid = state.isFaceSturdy((BlockGetter)level, pos, face);
            DevInfo.addInfoLine(lines, "Side", String.valueOf(face) + " (" + (solid ? "solid" : "not solid") + ")");
        }
        DevInfo.addInfoLine(lines, "Sky", "canSeeSky=" + ForgeBlock.isUnderOpenSky((Level)level, pos) + " isUnderRain=" + ForgeBlock.isUnderRain((Level)level, pos));
        DevInfo.addInfoLine(lines, "BlockPos", Args.join(Args.get("x", pos.getX()), Args.get("y", pos.getY()), Args.get("z", pos.getZ())));
        DevInfo.addInfoLine(lines, "Shape", state.getShape((BlockGetter)level, pos));
        DevInfo.addInfoLine(lines, "CollisionShape", state.getCollisionShape((BlockGetter)level, pos));
        if (state.isRandomlyTicking()) {
            DevInfo.addInfoLine(lines, "Ticks", "randomlyTicking");
        }
        Optional.ofNullable(level.getBlockEntity(pos)).ifPresent(tile -> {
            DevInfo.addInfoLine(lines, "TileEntity", tile);
            DevInfo.addCompoundInfo(tile.saveWithoutMetadata((HolderLookup.Provider)level.registryAccess()), lines, IEmitter.COMMON_ACTIVE_TAG_NAME);
        });
    }

    static void addEntityInfo(Entity entity, List<Component> lines) {
        DevInfo.addCaptionLine(lines, "Entity Info");
        DevInfo.addInfoLine(lines, "id", BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()));
        DevInfo.addInfoLine(lines, "name", entity.getName());
        DevInfo.addInfoLine(lines, "isUnderRain", ForgeEntity.isUnderRain(entity));
        DevInfo.addCompoundInfo(ForgeEntity.serializeToNBT(entity), lines, IEmitter.COMMON_ACTIVE_TAG_NAME);
    }

    protected static void addItemInfo(Level level, ItemStack stack, List<Component> lines) {
        Item item = stack.getItem();
        UnitId unitId = UnitId.from(item);
        if (stack.isDamageableItem()) {
            DevInfo.addInfoLine(lines, "Durability", stack.getMaxDamage());
        }
        lines.add((Component)DevInfo.formatedId(unitId));
        Optional.of(ForgeItem.getMaxBurnTime(stack, level.fuelValues())).filter(ticks -> ticks != 0).map(ticks -> ticks + " (carbon: " + (double)ticks.intValue() / 1600.0 + ")").ifPresent(string -> DevInfo.addInfoLine(lines, "BurnTime", string));
        DevInfo.addInfoLine(lines, "Category", CreativeModeTabs.allTabs().stream().filter(tab -> tab.getDisplayItems().stream().anyMatch(it -> it.is(item))).findFirst().map(tab -> tab.getDisplayName().getString()).orElse("none"));
        if (GameKeys.isShiftDown()) {
            DevInfo.addInfoLine(lines, "ItemTags", item.builtInRegistryHolder().tags().map(TagKey::location).toList());
            if (item instanceof BucketItem) {
                BucketItem bucket = (BucketItem)item;
                DevInfo.addInfoLine(lines, "FluidTags", bucket.content.builtInRegistryHolder().tags().map(TagKey::location).toList());
            }
        }
        if (GameKeys.isControlDown()) {
            DevInfo.addDataComponents(stack.getComponents(), lines, name -> true);
        }
    }

    protected static void addDataComponents(DataComponentMap components, List<Component> lines, Predicate<String> name) {
        if (!components.isEmpty()) {
            lines.add((Component)DevInfo.caption("DataComponents"));
            for (TypedDataComponent component : components) {
                lines.add((Component)DevInfo.literal(component.toString()));
            }
        } else {
            lines.add((Component)Component.literal((String)"no DataComponents"));
        }
    }

    protected static void addCompoundInfo(CompoundTag compound, List<Component> lines, Predicate<String> name) {
        if (compound != null) {
            lines.add((Component)DevInfo.caption("NBT"));
            for (String key : compound.keySet()) {
                TagHelper.Types type = TagHelper.getType(compound, key);
                if (!name.test(key) || !type.isOrdinal() && type != TagHelper.Types.STRING) continue;
                String line = String.valueOf((Object)type) + " " + key;
                line = line + " = " + String.valueOf(compound.get(key));
                lines.add((Component)DevInfo.literal(line));
            }
        } else {
            lines.add((Component)Component.literal((String)"no NBT"));
        }
    }

    protected static MutableComponent caption(String caption) {
        return Component.literal((String)"").append((Component)Component.literal((String)caption).withStyle(ChatFormatting.ITALIC)).append(": ");
    }

    protected static MutableComponent literal(String string) {
        return Component.literal((String)string).withStyle(ChatFormatting.RESET);
    }

    protected static MutableComponent formatedId(UnitId id) {
        return DevInfo.caption("ID").append((Component)DevInfo.literal(id.toString()));
    }
}

