/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.data;

import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.blocks.IEmitter;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.data.INBTSource;
import com.endertech.minecraft.forge.data.TagHelper;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.tiles.ForgeTile;
import com.endertech.minecraft.forge.units.UnitId;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ColorArgument;
import net.minecraft.commands.arguments.RangeArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.apache.commons.lang3.tuple.Pair;

public class ServerCommand {
    protected final LiteralArgumentBuilder<CommandSourceStack> builder;
    protected final CommandDispatcher<CommandSourceStack> dispatcher;
    protected final List<Task> tasks = new ArrayList<Task>();

    public ServerCommand(String name, CommandDispatcher<CommandSourceStack> dispatcher) {
        this.builder = Commands.literal((String)name);
        this.dispatcher = dispatcher;
    }

    public static ServerCommand create(AbstractForgeMod mod, CommandDispatcher<CommandSourceStack> dispatcher) {
        String commandName = mod.getId().replaceFirst("^ad", "");
        return new ServerCommand(commandName, dispatcher);
    }

    public Task task(String name) {
        Task task = new Task(name);
        this.tasks.add(task);
        return task;
    }

    public ServerCommand requires(OpLevel level) {
        this.builder.requires(src -> src.hasPermission(level.ordinal()));
        return this;
    }

    public void register() {
        for (Task task : this.tasks) {
            this.builder.then(task.builder);
        }
        this.dispatcher.register(this.builder);
    }

    public static class Task {
        protected final LiteralArgumentBuilder<CommandSourceStack> builder;

        public Task(String name) {
            this.builder = Commands.literal((String)name);
        }

        protected Command<CommandSourceStack> asCommand(Consumer<Context> method) {
            return context -> {
                method.accept(new Context((CommandContext<CommandSourceStack>)context));
                return 1;
            };
        }

        public Task executes(Consumer<Context> method, Arg<?> ... arguments) {
            RequiredArgumentBuilder argumentBuilder = null;
            for (int i = arguments.length - 1; i >= 0; --i) {
                Arg<?> arg = arguments[i];
                RequiredArgumentBuilder builder = Commands.argument((String)arg.getName(), arg.getType());
                if (arg.getCustomSuggestions().isPresent()) {
                    builder.suggests(arg.getCustomSuggestions().get());
                } else {
                    builder.suggests((arg_0, arg_1) -> arg.getType().listSuggestions(arg_0, arg_1));
                }
                if (argumentBuilder != null) {
                    builder.then(argumentBuilder);
                } else {
                    builder.executes(this.asCommand(method));
                }
                argumentBuilder = builder;
            }
            if (argumentBuilder != null) {
                this.builder.then(argumentBuilder);
            } else {
                this.builder.executes(this.asCommand(method));
            }
            return this;
        }

        public Task executes(Consumer<Context> method, String argName) {
            this.builder.then(Commands.literal((String)argName).executes(this.asCommand(method)));
            return this;
        }
    }

    public static enum OpLevel {
        ALL,
        MODERATORS,
        GAMEMASTERS,
        ADMINS,
        OWNERS;

    }

    public static class Arg<T> {
        private final String name;
        private final ArgumentType<T> type;
        private final SuggestionProvider<CommandSourceStack> customSuggestions;

        protected Arg(String name, ArgumentType<T> type) {
            this(name, type, null);
        }

        protected Arg(String name, ArgumentType<T> type, SuggestionProvider<CommandSourceStack> customSuggestions) {
            this.name = name;
            this.type = type;
            this.customSuggestions = customSuggestions;
        }

        public static <T> Arg<T> of(String name, ArgumentType<T> type) {
            return new Arg<T>(name, type);
        }

        public static <T> Arg<T> of(String name, ArgumentType<T> type, SuggestionProvider<CommandSourceStack> customSuggestions) {
            return new Arg<T>(name, type, customSuggestions);
        }

        public static Arg<Integer> integer(String name, IntBounds bounds) {
            return Arg.of(name, IntegerArgumentType.integer((int)bounds.getMin(), (int)bounds.getMax()));
        }

        public static Arg<Float> floatt(String name, FloatBounds bounds) {
            return Arg.of(name, FloatArgumentType.floatArg((float)bounds.getMin().floatValue(), (float)bounds.getMax().floatValue()));
        }

        public static Arg<String> string(String name) {
            return Arg.of(name, StringArgumentType.string());
        }

        public static Arg<String> string(String name, SuggestionProvider<CommandSourceStack> customSuggestions) {
            return Arg.of(name, StringArgumentType.string(), customSuggestions);
        }

        public static Arg<String> word(String name) {
            return Arg.of(name, StringArgumentType.word());
        }

        public static Arg<String> word(String name, SuggestionProvider<CommandSourceStack> customSuggestions) {
            return Arg.of(name, StringArgumentType.word(), customSuggestions);
        }

        public static Arg<MinMaxBounds.Ints> bounds(String name, IntBounds bounds) {
            return Arg.of(name, new RangeArgument.Ints());
        }

        public static Arg<MinMaxBounds.Doubles> bounds(String name, FloatBounds bounds) {
            return Arg.of(name, new RangeArgument.Floats());
        }

        public static Arg<ChatFormatting> color(String name) {
            return Arg.of(name, ColorArgument.color());
        }

        public String getName() {
            return this.name;
        }

        public ArgumentType<T> getType() {
            return this.type;
        }

        public Optional<SuggestionProvider<CommandSourceStack>> getCustomSuggestions() {
            return Optional.ofNullable(this.customSuggestions);
        }
    }

    public static class Msg {
        protected final String text;

        public Msg(String text) {
            this.text = text;
        }

        public static Msg of(String text) {
            return new Msg(text);
        }

        public static Msg noUnitInSight(String unit) {
            return Msg.colored("No " + unit + " in sight", ChatFormatting.RED);
        }

        public static Msg error(String error) {
            return Msg.colored(error, ChatFormatting.RED);
        }

        public static Msg colored(String text, ChatFormatting color) {
            return Msg.of(String.valueOf(color) + text + String.valueOf(ChatFormatting.RESET));
        }

        public static Msg bool(boolean value) {
            return Msg.colored(String.valueOf(value), value ? ChatFormatting.GREEN : ChatFormatting.RED);
        }

        public static Msg unit(String title, ChatFormatting color, UnitId id) {
            return Msg.of(String.valueOf(Msg.colored(title, color)) + " -> " + String.valueOf(Msg.colored(id.toString(), color)));
        }

        public static Msg emitter(String name, IEmitter emitter, boolean active) {
            return Msg.of(name + String.valueOf(Msg.colored(" is ", ChatFormatting.WHITE)) + String.valueOf(active ? Msg.colored("Active", ChatFormatting.RED) : Msg.colored("Inactive", ChatFormatting.GRAY)) + " " + String.valueOf(Msg.colored(emitter.toString(), ChatFormatting.DARK_AQUA)));
        }

        public static Msg clazz(Class<?> clazz, boolean fullName) {
            return Msg.colored("Class<" + (fullName ? clazz.getTypeName() : clazz.getSimpleName()) + ">", ChatFormatting.DARK_PURPLE);
        }

        public static Msg nbt(INBTSource<?> nbtSource, Predicate<String> tagNameFilter) {
            CompoundTag compound = nbtSource.serialize();
            ArrayList<String> tags = new ArrayList<String>();
            for (String key : compound.keySet()) {
                TagHelper.Types type = TagHelper.getType(compound, key);
                if (!tagNameFilter.test(key) || !type.isOrdinal() && type != TagHelper.Types.STRING) continue;
                tags.add(key);
            }
            return Msg.colored("NbtTags: " + String.valueOf(tags), ChatFormatting.DARK_AQUA);
        }

        public String toString() {
            return this.text;
        }
    }

    public static class Context {
        protected final CommandContext<CommandSourceStack> context;
        public final CommandSourceStack source;
        protected float reachDistance = 5.0f;

        public Context(CommandContext<CommandSourceStack> context) {
            this.context = context;
            this.source = (CommandSourceStack)context.getSource();
        }

        public ServerLevel getLevel() {
            return this.source.getLevel();
        }

        public BlockPos getBlockPos() {
            return BlockPos.containing((Position)this.source.getPosition());
        }

        public void sendMessage(String text) {
            this.sendMessage(Msg.of(text));
        }

        public void sendMessage(Msg msg) {
            this.source.sendSuccess(() -> Component.literal((String)msg.toString()), false);
        }

        public void setReachDistance(float value) {
            this.reachDistance = value;
        }

        @Nullable
        public Entity getEntity() {
            return this.source.getEntity();
        }

        public <V> V getArgument(String name, Class<V> type) {
            return (V)this.context.getArgument(name, type);
        }

        public Optional<Pair<BlockPos, Msg>> getTargetBlockInfo(boolean showErrorMessages) {
            Optional<BlockHitResult> result = this.rayTraceBlockBeingLookedAt(showErrorMessages);
            if (result.isPresent()) {
                BlockPos pos = result.get().getBlockPos();
                BlockState state = this.getLevel().getBlockState(pos);
                return Optional.of(Pair.of((Object)pos, (Object)Msg.unit("Target block", ChatFormatting.GREEN, UnitId.from(state))));
            }
            return Optional.empty();
        }

        public Optional<Pair<BlockPos, Msg>> getTargetTileInfo(Predicate<String> nbtNameFilter, boolean showErrorMessages) {
            ServerLevel world = this.getLevel();
            Optional<Pair<BlockPos, Msg>> info = this.getTargetBlockInfo(true);
            if (info.isPresent()) {
                BlockPos pos = (BlockPos)info.get().getKey();
                BlockEntity tile = world.getBlockEntity(pos);
                if (tile != null) {
                    UnitId id = ForgeTile.getRegistryName(tile).map(UnitId::from).orElse(UnitId.EMPTY);
                    Msg msg = Msg.of(String.valueOf(Msg.unit("Target tile", ChatFormatting.BLUE, id)) + " of " + String.valueOf(Msg.clazz(tile.getClass(), true)) + " with " + String.valueOf(Msg.nbt(INBTSource.of(tile), nbtNameFilter)));
                    return Optional.of(Pair.of((Object)pos, (Object)msg));
                }
                if (showErrorMessages) {
                    this.sendMessage(String.valueOf(info.get().getValue()) + " " + String.valueOf(Msg.error("has no tile")));
                }
            }
            return Optional.empty();
        }

        public Optional<Pair<Entity, Msg>> getTargetEntityInfo(boolean showErrorMessages, boolean includeClass, Optional<Predicate<String>> nbtNameFilter) {
            EntityHitResult result = ForgeEntity.rayTraceEntityBeingLookedAt(this.getEntity(), 1.0f, this.reachDistance).orElse(null);
            if (result != null) {
                Entity entity = result.getEntity();
                UnitId id = UnitId.from(ForgeEntity.getRegistryName(entity));
                String text = String.valueOf(Msg.unit("Target entity", ChatFormatting.YELLOW, id)) + (String)(includeClass ? " of " + String.valueOf(Msg.clazz(entity.getClass(), true)) : "") + (String)(nbtNameFilter.isPresent() ? " with " + String.valueOf(Msg.nbt(INBTSource.of(entity), nbtNameFilter.get())) : "");
                return Optional.of(Pair.of((Object)entity, (Object)Msg.of(text)));
            }
            if (showErrorMessages) {
                this.sendMessage(Msg.noUnitInSight("entity"));
            }
            return Optional.empty();
        }

        public Optional<Pair<BlockPos, Msg>> getTargetFluidInfo(boolean showErrorMessages) {
            Optional<BlockHitResult> result = this.rayTraceBlockBeingLookedAt(showErrorMessages);
            if (result.isPresent()) {
                BlockPos pos = result.get().getBlockPos();
                FluidState state = this.getLevel().getFluidState(pos);
                if (!state.isEmpty()) {
                    return Optional.of(Pair.of((Object)pos, (Object)Msg.unit("Target fluid", ChatFormatting.AQUA, UnitId.from(state))));
                }
            }
            if (showErrorMessages) {
                this.sendMessage(Msg.noUnitInSight("fluid"));
            }
            return Optional.empty();
        }

        public Optional<Pair<Item, Msg>> getHeldItemInfo(InteractionHand hand, boolean showErrorMessages) {
            if (this.getEntity() instanceof LivingEntity) {
                Optional<ItemStack> stack = Optional.of(((LivingEntity)this.getEntity()).getItemInHand(hand));
                if (stack.isPresent()) {
                    Item item = stack.get().getItem();
                    return Optional.of(Pair.of((Object)item, (Object)Msg.unit("Held item", ChatFormatting.DARK_PURPLE, UnitId.from(item))));
                }
                if (showErrorMessages) {
                    this.sendMessage(Msg.error("Hand is empty"));
                }
            } else if (showErrorMessages) {
                this.sendMessage(Msg.error("Entity is not living"));
            }
            return Optional.empty();
        }

        public Optional<BlockHitResult> rayTraceBlockBeingLookedAt(boolean showErrorMessages) {
            Entity entity = this.getEntity();
            if (entity == null) {
                if (showErrorMessages) {
                    this.sendMessage(Msg.error("Sender entity is null"));
                }
                return Optional.empty();
            }
            ArrayList<BlockHitResult> results = new ArrayList<BlockHitResult>();
            for (ClipContext.Block blockmod : ClipContext.Block.values()) {
                ForgeEntity.rayTraceBlockBeingLookedAt(entity, blockmod, ClipContext.Fluid.ANY, 1.0f, this.reachDistance).ifPresent(results::add);
            }
            results.removeIf(result -> result.getType() != HitResult.Type.BLOCK);
            double minDistance = Double.MAX_VALUE;
            BlockHitResult closestResult = null;
            for (BlockHitResult result2 : results) {
                double distance = entity.getEyePosition(1.0f).distanceToSqr(result2.getLocation());
                if (!(distance < minDistance)) continue;
                closestResult = result2;
                minDistance = distance;
            }
            if (closestResult != null) {
                return Optional.of(closestResult);
            }
            if (showErrorMessages) {
                this.sendMessage(Msg.noUnitInSight("block"));
            }
            return Optional.empty();
        }
    }
}

