/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.entities;

import com.endertech.common.CommonTime;
import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.world.GameWorld;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

public class LivingHealthRegen<L extends LivingEntity>
implements IHaveConfig {
    protected final GameTime updateInterval = GameTime.quaterSecond();
    private final UnitConfig config;
    private final Class<L> livingClass;
    private final CommonTime.Interval afterHurtCooldown;
    private final float healOnEachUpdate;
    protected Map<L, CommonTime.Stamp> lastHurtsMap = new HashMap<L, CommonTime.Stamp>();

    public LivingHealthRegen(AbstractForgeMod mod, UnitConfig config, Class<L> livingClass, float cooldownInSeconds, float healOnEachUpdate) {
        this.config = config;
        this.livingClass = livingClass;
        cooldownInSeconds = UnitConfig.getFloat(config, this.getClassCategory(), "afterHurtCooldown", cooldownInSeconds, FloatBounds.between(Float.valueOf(0.0f), Float.valueOf(360.0f)), "Defines the cooldown period of time (in seconds) after being hurt till regeneration start");
        this.afterHurtCooldown = CommonTime.Interval.seconds(cooldownInSeconds);
        this.healOnEachUpdate = UnitConfig.getFloat(config, this.getClassCategory(), "healOnEachUpdate", healOnEachUpdate, FloatBounds.between(Float.valueOf(0.0f), Float.valueOf(5.0f)), "Defines the amount of health (in half-hearts) to be restored in each update (a quarter of second)");
        this.saveConfig();
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onLivingUpdate(EntityTickEvent event) {
        CommonTime.Stamp lastHurt;
        LivingEntity living;
        Level level;
        LivingEntity entity;
        Entity entity2 = event.getEntity();
        if (entity2 instanceof LivingEntity && this.isProperLivingClass(entity = (LivingEntity)entity2) && GameWorld.isServerSide((LevelReader)(level = (living = entity).level())) && ((lastHurt = this.lastHurtsMap.get(living)) == null || CommonTime.Interval.passedFrom(lastHurt).moreThan(this.afterHurtCooldown)) && this.updateInterval.pastIn(level) && LivingHealthRegen.needsHealing(living)) {
            float healAmount = this.getHealAmount(living);
            living.heal(healAmount);
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingDamageEvent.Post event) {
        LivingEntity living = event.getEntity();
        if (this.isProperLivingClass(living)) {
            this.lastHurtsMap.put(living, CommonTime.Stamp.now());
        }
    }

    protected boolean isProperLivingClass(LivingEntity living) {
        return this.livingClass.isAssignableFrom(living.getClass());
    }

    @Override
    public UnitConfig getConfig() {
        return this.config;
    }

    public float getHealAmount(L living) {
        return this.healOnEachUpdate;
    }

    public static boolean needsHealing(LivingEntity living) {
        return living.getHealth() > 0.0f && living.getHealth() < living.getMaxHealth();
    }
}

