/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.items;

import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.items.DamageableItem;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.equipment.Equippable;

public class EquipmentItem
extends DamageableItem {
    public EquipmentItem(UnitConfig config, Properties<?> props) {
        super(config, (DamageableItem.Properties<?>)props);
    }

    public static class Properties<T extends Properties<T>>
    extends DamageableItem.Properties<T> {
        public static Properties<?> of(ResourceKey<Item> key) {
            return new Properties<Properties>(Properties.class, key);
        }

        protected Properties(Class<T> selfClass, ResourceKey<Item> key) {
            super(selfClass, key);
        }

        public T equippable(Equippable equippable) {
            this.vanillaProps.component(DataComponents.EQUIPPABLE, (Object)equippable);
            return (T)((Properties)this.self);
        }

        public T equippable(EquipmentSlot slot, Holder<SoundEvent> sound, boolean swappable) {
            return this.equippable(Equippable.builder((EquipmentSlot)slot).setEquipSound(sound).setSwappable(swappable).build());
        }

        public T equippable(EquipmentSlot slot, SoundEvent sound, boolean swappable) {
            Holder soundHolder = BuiltInRegistries.SOUND_EVENT.wrapAsHolder((Object)sound);
            return this.equippable(slot, (Holder<SoundEvent>)soundHolder, swappable);
        }

        public T equippable(EquipmentSlot slot, SoundEvent sound) {
            return this.equippable(slot, sound, true);
        }
    }
}

