/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.math;

import java.util.Random;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;

public class RandomWrapper
extends Random
implements RandomSource {
    protected final RandomSource source;

    public static Random of(RandomSource source) {
        return new RandomWrapper(source);
    }

    protected RandomWrapper(RandomSource source) {
        super(source.nextLong());
        this.source = source;
    }

    public RandomSource fork() {
        return this.source.fork();
    }

    public PositionalRandomFactory forkPositional() {
        return this.source.forkPositional();
    }

    @Override
    public void setSeed(long pSeed) {
        super.setSeed(pSeed);
        if (this.source != null) {
            this.source.setSeed(pSeed);
        }
    }

    @Override
    public int nextInt() {
        return this.source.nextInt();
    }

    @Override
    public int nextInt(int pBound) {
        return this.source.nextInt(pBound);
    }

    @Override
    public int nextInt(int origin, int bound) {
        return this.source.nextInt(origin, bound);
    }

    @Override
    public long nextLong() {
        return this.source.nextLong();
    }

    @Override
    public boolean nextBoolean() {
        return this.source.nextBoolean();
    }

    @Override
    public float nextFloat() {
        return this.source.nextFloat();
    }

    @Override
    public double nextDouble() {
        return this.source.nextDouble();
    }

    @Override
    public double nextGaussian() {
        return this.source.nextGaussian();
    }
}

