/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.mixin;

import com.endertech.minecraft.forge.items.DamageableItem;
import com.endertech.minecraft.forge.items.ForgeItem;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin {
    @Inject(method={"isValidRepairItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void isValidRepairItem(ItemStack stack, CallbackInfoReturnable<Boolean> callback) {
        DamageableItem damageableItem;
        Item item = ((ItemStack)this).getItem();
        if (item instanceof DamageableItem && (damageableItem = (DamageableItem)item).isValidRepairItem(stack)) {
            callback.setReturnValue((Object)true);
        }
    }

    @Inject(method={"inventoryTick"}, at={@At(value="HEAD")})
    public void inventoryTick(Level level, Entity entity, @Nullable EquipmentSlot slot, CallbackInfo callback) {
        Item item;
        ItemStack stack = (ItemStack)this;
        if (level.isClientSide() && (item = stack.getItem()) instanceof ForgeItem) {
            ForgeItem forgeItem = (ForgeItem)item;
            forgeItem.inventoryTickClient(stack, level, entity, slot);
        }
    }
}

