/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.mixin;

import com.endertech.minecraft.forge.events.ChunkDataLoadedEvent;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.storage.SerializableChunkData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SerializableChunkData.class})
public abstract class SerializableChunkDataMixin {
    @Inject(method={"parse"}, at={@At(value="RETURN")})
    private static void parse(LevelHeightAccessor heightAccessor, RegistryAccess registryAccess, CompoundTag data, CallbackInfoReturnable<SerializableChunkData> callbackInfo) {
        if (heightAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)heightAccessor;
            if (data.contains("Status")) {
                ChunkPos pos = new ChunkPos(data.getIntOr("xPos", 0), data.getIntOr("zPos", 0));
                CompoundTag structures = data.getCompoundOrEmpty("structures");
                ChunkDataLoadedEvent.post(level, pos, structures);
            }
        }
    }
}

