/*
 * Decompiled with CFR 0.152.
 */
package fuzs.eternalnether.client.renderer.entity;

import fuzs.eternalnether.EternalNether;
import fuzs.eternalnether.client.model.geom.ModModelLayers;
import fuzs.eternalnether.world.entity.monster.Corpor;
import net.minecraft.client.model.SkeletonModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.AbstractSkeletonRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.SkeletonRenderState;
import net.minecraft.resources.ResourceLocation;

public class CorporRenderer
extends AbstractSkeletonRenderer<Corpor, SkeletonRenderState> {
    private static final ResourceLocation TEXTURE_LOCATION = EternalNether.id("textures/entity/skeleton/corpor.png");

    public CorporRenderer(EntityRendererProvider.Context context) {
        super(context, ModModelLayers.CORPOR, ModModelLayers.CORPOR_INNER_ARMOR, ModModelLayers.CORPOR_OUTER_ARMOR);
    }

    public static LayerDefinition createBodyLayer() {
        return SkeletonModel.createBodyLayer().apply(meshDefinition -> {
            CorporRenderer.modifyMesh(meshDefinition);
            return meshDefinition;
        });
    }

    private static void modifyMesh(MeshDefinition meshDefinition) {
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.5f, -9.0f, -4.0f, 9.0f, 10.0f, 6.0f), PartPose.ZERO);
    }

    public ResourceLocation getTextureLocation(SkeletonRenderState renderState) {
        return TEXTURE_LOCATION;
    }

    public SkeletonRenderState createRenderState() {
        return new SkeletonRenderState();
    }
}

