/*
 * Decompiled with CFR 0.152.
 */
package fuzs.eternalnether.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fuzs.eternalnether.EternalNether;
import fuzs.eternalnether.client.model.geom.ModModelLayers;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PiglinModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.PiglinRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.EquipmentAssetManager;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.Equippable;

public class HoglinSkullLayer
extends RenderLayer<PiglinRenderState, PiglinModel> {
    private static final ResourceLocation SKULL_TEXTURE_LOCATION = EternalNether.id("textures/entity/piglin/piglin_hunter_skull.png");
    private final HumanoidModel<PiglinRenderState> model;
    private final EquipmentAssetManager equipmentAssets;

    public HoglinSkullLayer(RenderLayerParent<PiglinRenderState, PiglinModel> renderLayerParent, EntityModelSet entityModels, EquipmentAssetManager equipmentAssets) {
        super(renderLayerParent);
        this.model = new HumanoidModel(entityModels.bakeLayer(ModModelLayers.PIGLIN_HUNTER_SKULL));
        this.equipmentAssets = equipmentAssets;
    }

    public static LayerDefinition createSkullLayer() {
        MeshDefinition meshDefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition partDefinition2 = partDefinition.clearChild("head");
        partDefinition2.clearChild("hat");
        PartDefinition partDefinition3 = partDefinition.clearChild("body");
        partDefinition.clearChild("left_arm");
        partDefinition.clearChild("right_arm");
        partDefinition.clearChild("left_leg");
        partDefinition.clearChild("right_leg");
        PartDefinition partDefinition4 = partDefinition3.addOrReplaceChild("skull", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)-8.9f, (float)-3.3f, (float)0.65449846f, (float)((float)Math.PI), (float)0.0f));
        PartDefinition partDefinition5 = partDefinition4.addOrReplaceChild("head", CubeListBuilder.create().texOffs(61, 1).addBox(-7.0f, -3.0f, -19.0f, 14.0f, 6.0f, 19.0f), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)-12.0f, (float)0.87266463f, (float)0.0f, (float)0.0f));
        partDefinition5.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(1, 1).addBox(-6.0f, -1.0f, -2.0f, 6.0f, 1.0f, 4.0f), PartPose.offsetAndRotation((float)-6.0f, (float)-2.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)-0.6981317f));
        partDefinition5.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(1, 6).addBox(0.0f, -1.0f, -2.0f, 6.0f, 1.0f, 4.0f), PartPose.offsetAndRotation((float)6.0f, (float)-2.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.6981317f));
        partDefinition5.addOrReplaceChild("right_horn", CubeListBuilder.create().texOffs(10, 13).addBox(-1.0f, -11.0f, -1.0f, 2.0f, 11.0f, 2.0f), PartPose.offset((float)-7.0f, (float)2.0f, (float)-12.0f));
        partDefinition5.addOrReplaceChild("left_horn", CubeListBuilder.create().texOffs(1, 13).addBox(-1.0f, -11.0f, -1.0f, 2.0f, 11.0f, 2.0f), PartPose.offset((float)7.0f, (float)2.0f, (float)-12.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)128, (int)64);
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, PiglinRenderState renderState, float yRot, float xRot) {
        if (!renderState.isBaby) {
            poseStack.pushPose();
            if (this.hasLayer(renderState.chestEquipment, EquipmentClientInfo.LayerType.HUMANOID)) {
                poseStack.translate(0.0f, 0.0f, 0.06875f);
            }
            if (renderState.isPassenger) {
                poseStack.translate(0.0f, -0.4375f, 0.0f);
            }
            VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)SKULL_TEXTURE_LOCATION));
            ((PiglinModel)this.getParentModel()).copyPropertiesTo(this.model);
            this.model.setupAnim((HumanoidRenderState)renderState);
            this.model.renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY);
            poseStack.popPose();
        }
    }

    private boolean hasLayer(ItemStack stack, EquipmentClientInfo.LayerType layer) {
        Equippable equippable = (Equippable)stack.get(DataComponents.EQUIPPABLE);
        if (equippable != null && !equippable.assetId().isEmpty()) {
            EquipmentClientInfo equipmentClientInfo = this.equipmentAssets.get((ResourceKey)equippable.assetId().get());
            return !equipmentClientInfo.getLayers(layer).isEmpty();
        }
        return false;
    }
}

