/*
 * Decompiled with CFR 0.152.
 */
package fuzs.eternalnether.init;

import fuzs.eternalnether.init.ModEntityTypes;
import fuzs.eternalnether.init.ModRegistry;
import fuzs.eternalnether.init.ModTags;
import fuzs.eternalnether.world.level.levelgen.structure.CatacombStructure;
import fuzs.eternalnether.world.level.levelgen.structure.CitadelStructure;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.random.Weighted;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public final class ModStructures {
    public static final ResourceKey<Structure> CATACOMB_STRUCTURE = ModRegistry.REGISTRIES.makeResourceKey(Registries.STRUCTURE, "catacomb");
    public static final ResourceKey<Structure> CITADEL_STRUCTURE = ModRegistry.REGISTRIES.makeResourceKey(Registries.STRUCTURE, "citadel");
    public static final ResourceKey<Structure> PIGLIN_MANOR_STRUCTURE = ModRegistry.REGISTRIES.makeResourceKey(Registries.STRUCTURE, "piglin_manor");
    public static final ResourceKey<StructureTemplatePool> CATACOMB_START_POOL = ModRegistry.REGISTRIES.makeResourceKey(Registries.TEMPLATE_POOL, "catacomb/start_pool");
    public static final ResourceKey<StructureTemplatePool> CITADEL_START_POOL = ModRegistry.REGISTRIES.makeResourceKey(Registries.TEMPLATE_POOL, "citadel/start_pool");
    public static final ResourceKey<StructureTemplatePool> PIGLIN_MANOR_START_POOL = ModRegistry.REGISTRIES.makeResourceKey(Registries.TEMPLATE_POOL, "piglin_manor/start_pool");

    public static void bootstrapStructures(BootstrapContext<Structure> context) {
        context.register(CATACOMB_STRUCTURE, (Object)new CatacombStructure(new Structure.StructureSettings.Builder((HolderSet)context.lookup(Registries.BIOME).getOrThrow(ModTags.HAS_CATACOMB_BIOME_TAG_KEY)).spawnOverrides(Map.of(MobCategory.MONSTER, new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.PIECE, WeightedList.of((Object)new MobSpawnSettings.SpawnerData(EntityType.MAGMA_CUBE, 1, 1))))).generationStep(GenerationStep.Decoration.UNDERGROUND_DECORATION).build(), (Holder<StructureTemplatePool>)context.lookup(Registries.TEMPLATE_POOL).getOrThrow(CATACOMB_START_POOL), Optional.empty(), 3, (HeightProvider)UniformHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)56), (VerticalAnchor)VerticalAnchor.absolute((int)84)), Optional.empty(), 128));
        context.register(CITADEL_STRUCTURE, (Object)new CitadelStructure(new Structure.StructureSettings.Builder((HolderSet)context.lookup(Registries.BIOME).getOrThrow(ModTags.HAS_CITADEL_BIOME_TAG_KEY)).spawnOverrides(Map.of(MobCategory.MONSTER, new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.PIECE, WeightedList.of((Weighted[])new Weighted[]{new Weighted((Object)new MobSpawnSettings.SpawnerData(EntityType.ENDERMAN, 1, 1), 1), new Weighted((Object)new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.WARPED_ENDERMAN.value(), 1, 1), 1)})))).generationStep(GenerationStep.Decoration.SURFACE_STRUCTURES).terrainAdapation(TerrainAdjustment.BEARD_THIN).build(), (Holder<StructureTemplatePool>)context.lookup(Registries.TEMPLATE_POOL).getOrThrow(CITADEL_START_POOL), Optional.empty(), 4, (HeightProvider)UniformHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)48), (VerticalAnchor)VerticalAnchor.absolute((int)70)), Optional.empty(), 116));
        context.register(PIGLIN_MANOR_STRUCTURE, (Object)new CitadelStructure(new Structure.StructureSettings.Builder((HolderSet)context.lookup(Registries.BIOME).getOrThrow(ModTags.HAS_PIGLIN_MANOR_BIOME_TAG_KEY)).spawnOverrides(Map.of(MobCategory.MONSTER, new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.PIECE, WeightedList.of((Weighted[])new Weighted[]{new Weighted((Object)new MobSpawnSettings.SpawnerData(EntityType.PIGLIN, 1, 1), 2), new Weighted((Object)new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.PIGLIN_HUNTER.value(), 1, 1), 1)})))).generationStep(GenerationStep.Decoration.SURFACE_STRUCTURES).terrainAdapation(TerrainAdjustment.BEARD_THIN).build(), (Holder<StructureTemplatePool>)context.lookup(Registries.TEMPLATE_POOL).getOrThrow(PIGLIN_MANOR_START_POOL), Optional.empty(), 1, (HeightProvider)UniformHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)34), (VerticalAnchor)VerticalAnchor.absolute((int)72)), Optional.empty(), 116));
    }
}

