/*
 * Decompiled with CFR 0.152.
 */
package fuzs.eternalnether.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fuzs.puzzleslib.api.config.v3.json.GsonCodecHelper;
import fuzs.puzzleslib.impl.PuzzlesLib;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.GsonHelper;

public abstract class DataFixer<T> {
    public static final DataFixer<?> JSON = new JsonDataFixer();
    public static final DataFixer<?> NBT = new NbtDataFixer();
    static final Collection<DataFixer<?>> ALL = List.of(JSON, NBT);
    private final String fileExtension;

    DataFixer(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    static void getAllFilesRecursive(File file, Consumer<File> fileOutput, Predicate<String> fileFilter) {
        File[] listedFiles = file.listFiles();
        if (listedFiles != null) {
            for (File listedFile : listedFiles) {
                if (listedFile.isDirectory()) {
                    DataFixer.getAllFilesRecursive(listedFile, fileOutput, fileFilter);
                    continue;
                }
                if (!fileFilter.test(listedFile.getName())) continue;
                fileOutput.accept(listedFile);
            }
        }
    }

    public static void updateAll(File inputDirectory, File outputDirectory, String targetValue, String replacementValue) {
        for (DataFixer<?> dataFixer : ALL) {
            dataFixer.update(inputDirectory, outputDirectory, targetValue, replacementValue);
        }
    }

    public final void update(File inputDirectory, File outputDirectory, String targetValue, String replacementValue) {
        ArrayList files = new ArrayList();
        DataFixer.getAllFilesRecursive(inputDirectory, files::add, s -> s.endsWith("." + this.fileExtension));
        Iterator iterator = files.iterator();
        while (iterator.hasNext()) {
            File inputFile = (File)iterator.next();
            File outputFile = outputDirectory.toPath().resolve(inputDirectory.toPath().relativize(inputFile.toPath())).toFile();
            outputFile.getParentFile().mkdirs();
            try {
                T t = this.read(inputFile);
                this.write(outputFile, this.process(t, targetValue, replacementValue));
            }
            catch (IOException exception) {
                PuzzlesLib.LOGGER.warn("Failed handling {}", (Object)outputFile, (Object)exception);
                iterator.remove();
            }
        }
    }

    public abstract T process(T var1, String var2, String var3);

    abstract T read(File var1) throws IOException;

    abstract void write(File var1, T var2) throws IOException;

    private static class JsonDataFixer
    extends DataFixer<JsonElement> {
        JsonDataFixer() {
            super("json");
        }

        @Override
        public JsonElement process(JsonElement jsonElement, String targetValue, String replacementValue) {
            block4: {
                block5: {
                    if (jsonElement == null || jsonElement.isJsonNull()) break block4;
                    if (jsonElement.isJsonPrimitive()) {
                        JsonPrimitive jsonPrimitive = jsonElement.getAsJsonPrimitive();
                        if (jsonPrimitive.isString() && jsonPrimitive.getAsString().contains(targetValue)) {
                            return new JsonPrimitive(jsonPrimitive.getAsString().replace(targetValue, replacementValue));
                        }
                        return jsonElement;
                    }
                    if (!jsonElement.isJsonArray()) break block5;
                    JsonArray jsonArray = jsonElement.getAsJsonArray();
                    for (int i = 0; i < jsonArray.size(); ++i) {
                        jsonArray.set(i, this.process(jsonArray.get(i), targetValue, replacementValue));
                    }
                    break block4;
                }
                if (!jsonElement.isJsonObject()) break block4;
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                for (Map.Entry entry : jsonObject.entrySet()) {
                    entry.setValue(this.process((JsonElement)entry.getValue(), targetValue, replacementValue));
                }
            }
            return jsonElement;
        }

        @Override
        JsonElement read(File file) throws IOException {
            try (FileReader fileReader = new FileReader(file);){
                JsonElement jsonElement = (JsonElement)GsonHelper.fromJson((Gson)GsonCodecHelper.GSON, (Reader)fileReader, JsonElement.class);
                return jsonElement;
            }
        }

        @Override
        void write(File file, JsonElement jsonElement) throws IOException {
            try (FileWriter fileWriter = new FileWriter(file);){
                GsonCodecHelper.GSON.toJson(jsonElement, (Appendable)fileWriter);
            }
        }
    }

    private static class NbtDataFixer
    extends DataFixer<CompoundTag> {
        NbtDataFixer() {
            super("nbt");
        }

        @Override
        public CompoundTag process(CompoundTag compoundTag, String targetValue, String replacementValue) {
            return this.processTag(compoundTag, targetValue, replacementValue);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private <T extends Tag> T processTag(T tag, String targetValue, String replacementValue) {
            if (tag == null) return tag;
            if (tag instanceof StringTag) {
                StringTag stringTag = (StringTag)tag;
                try {
                    String string;
                    String value = string = stringTag.value();
                    if (!value.contains(targetValue)) return tag;
                    return (T)StringTag.valueOf((String)value.replace(targetValue, replacementValue));
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            if (tag instanceof ListTag) {
                ListTag listTag = (ListTag)tag;
                for (int i = 0; i < listTag.size(); ++i) {
                    listTag.set(i, this.processTag(listTag.get(i), targetValue, replacementValue));
                }
                return tag;
            }
            if (!(tag instanceof CompoundTag)) return tag;
            CompoundTag compoundTag = (CompoundTag)tag;
            for (Map.Entry entry : compoundTag.entrySet()) {
                entry.setValue(this.processTag((Tag)entry.getValue(), targetValue, replacementValue));
            }
            return tag;
        }

        @Override
        CompoundTag read(File file) throws IOException {
            return NbtIo.readCompressed((Path)file.toPath(), (NbtAccounter)NbtAccounter.unlimitedHeap());
        }

        @Override
        void write(File file, CompoundTag tag) throws IOException {
            NbtIo.writeCompressed((CompoundTag)tag, (Path)file.toPath());
        }
    }
}

