/*
 * Decompiled with CFR 0.152.
 */
package fuzs.eternalnether.world.entity.ai.goal;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class OwnableEntityHelper {
    public static <T extends PathfinderMob> void tryToTeleportToOwner(T mob) {
        LivingEntity livingEntity = ((OwnableEntity)mob).getOwner();
        if (livingEntity != null) {
            OwnableEntityHelper.teleportToAroundBlockPos(mob, livingEntity.blockPosition());
        }
    }

    public static <T extends PathfinderMob> boolean shouldTryTeleportToOwner(T mob) {
        LivingEntity livingEntity = ((OwnableEntity)mob).getOwner();
        return livingEntity != null && mob.distanceToSqr((Entity)((OwnableEntity)mob).getOwner()) >= 144.0;
    }

    private static <T extends PathfinderMob> void teleportToAroundBlockPos(T mob, BlockPos pos) {
        for (int i = 0; i < 10; ++i) {
            int j = mob.getRandom().nextIntBetweenInclusive(-3, 3);
            int k = mob.getRandom().nextIntBetweenInclusive(-3, 3);
            if (Math.abs(j) < 2 && Math.abs(k) < 2) continue;
            int l = mob.getRandom().nextIntBetweenInclusive(-1, 1);
            if (!OwnableEntityHelper.maybeTeleportTo(mob, pos.getX() + j, pos.getY() + l, pos.getZ() + k)) continue;
            return;
        }
    }

    private static <T extends PathfinderMob> boolean maybeTeleportTo(T mob, int x, int y, int z) {
        if (!OwnableEntityHelper.canTeleportTo(mob, new BlockPos(x, y, z))) {
            return false;
        }
        mob.snapTo((double)x + 0.5, (double)y, (double)z + 0.5, mob.getYRot(), mob.getXRot());
        mob.getNavigation().stop();
        return true;
    }

    private static <T extends PathfinderMob> boolean canTeleportTo(T mob, BlockPos pos) {
        PathType pathType = WalkNodeEvaluator.getPathTypeStatic(mob, (BlockPos)pos);
        if (pathType != PathType.WALKABLE) {
            return false;
        }
        BlockState blockState = mob.level().getBlockState(pos.below());
        if (blockState.getBlock() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockPos = pos.subtract((Vec3i)mob.blockPosition());
        return mob.level().noCollision(mob, mob.getBoundingBox().move(blockPos));
    }

    public static <T extends PathfinderMob> boolean unableToMoveToOwner(T mob) {
        return mob.isPassenger() || mob.mayBeLeashed() || ((OwnableEntity)mob).getOwner() != null && ((OwnableEntity)mob).getOwner().isSpectator();
    }
}

