/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.client.item;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.properties.select.SelectItemModelProperty;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import sereneseasons.init.ModConfig;
import sereneseasons.init.ModTags;
import sereneseasons.item.CalendarType;

public class ContextCalendarType
implements SelectItemModelProperty<CalendarType> {
    public static final SelectItemModelProperty.Type<ContextCalendarType, CalendarType> TYPE = SelectItemModelProperty.Type.create((MapCodec)MapCodec.unit((Object)new ContextCalendarType()), CalendarType.CODEC);

    @Nullable
    public CalendarType get(ItemStack stack, @Nullable ClientLevel clientLevel, @Nullable LivingEntity livingEntity, int i, ItemDisplayContext itemDisplayContext) {
        Holder biome;
        LivingEntity holder;
        ClientLevel level = clientLevel;
        Object object = holder = livingEntity != null ? livingEntity : stack.getFrame();
        if (level == null && holder != null) {
            level = holder.level();
        }
        if (level == null || !ModConfig.seasons.isDimensionWhitelisted((ResourceKey<Level>)level.dimension())) {
            return CalendarType.NONE;
        }
        if (holder != null && (biome = level.getBiome(holder.blockPosition())).is(ModTags.Biomes.TROPICAL_BIOMES)) {
            return CalendarType.TROPICAL;
        }
        return CalendarType.STANDARD;
    }

    public Codec<CalendarType> valueCodec() {
        return CalendarType.CODEC;
    }

    public SelectItemModelProperty.Type<? extends SelectItemModelProperty<CalendarType>, CalendarType> type() {
        return TYPE;
    }
}

