/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.datagen.models;

import java.util.ArrayList;
import java.util.function.BiConsumer;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ItemModelOutput;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelInstance;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.RangeSelectItemModel;
import net.minecraft.client.renderer.item.SelectItemModel;
import net.minecraft.client.renderer.item.properties.numeric.RangeSelectItemModelProperty;
import net.minecraft.client.renderer.item.properties.select.SelectItemModelProperty;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import sereneseasons.api.SSItems;
import sereneseasons.client.item.ContextCalendarType;
import sereneseasons.client.item.SeasonTimeProperty;
import sereneseasons.item.CalendarType;

public class SSItemModelGenerators
extends ItemModelGenerators {
    private final ItemModelOutput itemModelOutput;
    private final BiConsumer<ResourceLocation, ModelInstance> modelOutput;

    public SSItemModelGenerators(ItemModelOutput itemModelOutput, BiConsumer<ResourceLocation, ModelInstance> modelOutput) {
        super(itemModelOutput, modelOutput);
        this.itemModelOutput = itemModelOutput;
        this.modelOutput = modelOutput;
    }

    public void generateCalendarItem(Item item) {
        int i;
        ItemModel.Unbaked nullCalendar = ItemModelUtils.plainModel((ResourceLocation)this.createFlatItemModel(item, "_null", ModelTemplates.FLAT_ITEM));
        ArrayList<RangeSelectItemModel.Entry> standardEntries = new ArrayList<RangeSelectItemModel.Entry>();
        ArrayList<RangeSelectItemModel.Entry> tropicalEntries = new ArrayList<RangeSelectItemModel.Entry>();
        ItemModel.Unbaked[] standardModels = new ItemModel.Unbaked[12];
        ItemModel.Unbaked[] tropicalModels = new ItemModel.Unbaked[6];
        for (i = 0; i < 12; ++i) {
            standardModels[i] = ItemModelUtils.plainModel((ResourceLocation)this.createFlatItemModel(item, String.format("_%02d", i), ModelTemplates.FLAT_ITEM));
            standardEntries.add(ItemModelUtils.override((ItemModel.Unbaked)standardModels[i], (float)((float)i / 12.0f)));
            if (i >= 6) continue;
            tropicalModels[i] = ItemModelUtils.plainModel((ResourceLocation)this.createFlatItemModel(item, String.format("_tropical_%02d", i), ModelTemplates.FLAT_ITEM));
        }
        for (i = 0; i < 12; ++i) {
            tropicalEntries.add(ItemModelUtils.override((ItemModel.Unbaked)tropicalModels[(i + 3) / 2 % 6], (float)((float)i / 12.0f)));
        }
        this.itemModelOutput.accept(item, ItemModelUtils.select((SelectItemModelProperty)new ContextCalendarType(), (SelectItemModel.SwitchCase[])new SelectItemModel.SwitchCase[]{ItemModelUtils.when((Object)((Object)CalendarType.STANDARD), (ItemModel.Unbaked)ItemModelUtils.rangeSelect((RangeSelectItemModelProperty)new SeasonTimeProperty(), (float)1.0f, standardEntries)), ItemModelUtils.when((Object)((Object)CalendarType.TROPICAL), (ItemModel.Unbaked)ItemModelUtils.rangeSelect((RangeSelectItemModelProperty)new SeasonTimeProperty(), (float)1.0f, tropicalEntries)), ItemModelUtils.when((Object)((Object)CalendarType.NONE), (ItemModel.Unbaked)nullCalendar)}));
    }

    public void run() {
        this.generateFlatItem(SSItems.SS_ICON, ModelTemplates.FLAT_ITEM);
        this.generateCalendarItem(SSItems.CALENDAR);
    }
}

