/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.init;

import glitchcore.event.EventManager;
import glitchcore.event.client.ItemTooltipEvent;
import glitchcore.event.client.RegisterColorsEvent;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import sereneseasons.api.SSItems;
import sereneseasons.api.season.ISeasonState;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.init.ModConfig;
import sereneseasons.init.ModFertility;
import sereneseasons.init.ModTags;
import sereneseasons.season.SeasonColorHandlers;
import sereneseasons.season.SeasonHandlerClient;
import sereneseasons.season.SeasonTime;
import sereneseasons.util.SeasonColorUtil;

public class ModClient {
    public static void setup() {
        SeasonColorHandlers.setup();
    }

    public static void addClientHandlers() {
        EventManager.addListener(SeasonHandlerClient::onClientTick);
        EventManager.addListener(ModFertility::setupTooltips);
        EventManager.addListener(ModClient::registerBlockColors);
        EventManager.addListener(ModClient::onItemTooltip);
    }

    public static void onItemTooltip(ItemTooltipEvent event) {
        List tooltip = event.getTooltip();
        Player player = event.getPlayer();
        if (event.getStack().getItem() != SSItems.CALENDAR) {
            return;
        }
        if (player != null && ModConfig.seasons.isDimensionWhitelisted((ResourceKey<Level>)player.level().dimension())) {
            int seasonCycleTicks = SeasonHelper.getSeasonState(player.level()).getSeasonCycleTicks();
            SeasonTime time = new SeasonTime(seasonCycleTicks);
            int subSeasonDuration = ModConfig.seasons.subSeasonDuration;
            tooltip.add(Component.translatable((String)("desc.sereneseasons." + time.getSubSeason().toString().toLowerCase(Locale.ROOT))).withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)" (").withStyle(ChatFormatting.DARK_GRAY)).append((Component)Component.translatable((String)("desc.sereneseasons." + time.getTropicalSeason().toString().toLowerCase(Locale.ROOT))).withStyle(ChatFormatting.DARK_GRAY)).append((Component)Component.literal((String)")").withStyle(ChatFormatting.DARK_GRAY)));
            tooltip.add(Component.translatable((String)"desc.sereneseasons.day_counter", (Object[])new Object[]{time.getDay() % subSeasonDuration + 1, subSeasonDuration}).withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"desc.sereneseasons.tropical_day_counter", (Object[])new Object[]{(time.getDay() + subSeasonDuration) % (subSeasonDuration * 2) + 1, subSeasonDuration * 2}).withStyle(ChatFormatting.DARK_GRAY)));
        } else {
            tooltip.add(Component.literal((String)"???").withStyle(ChatFormatting.GRAY));
        }
    }

    public static void registerItemProperties() {
    }

    private static void registerBlockColors(RegisterColorsEvent.Block event) {
        event.register((state, dimensionReader, pos, tintIndex) -> {
            Holder biome;
            int birchColor = -8345771;
            Level level = Minecraft.getInstance().player.level();
            ResourceKey dimension = Minecraft.getInstance().player.level().dimension();
            if (level != null && pos != null && ModConfig.seasons.changeBirchColor && ModConfig.seasons.isDimensionWhitelisted((ResourceKey<Level>)dimension) && !(biome = level.getBiome(pos)).is(ModTags.Biomes.BLACKLISTED_BIOMES)) {
                ISeasonState calendar = SeasonHelper.getSeasonState(level);
                Enum colorProvider = biome.is(ModTags.Biomes.TROPICAL_BIOMES) ? calendar.getTropicalSeason() : calendar.getSubSeason();
                birchColor = colorProvider.getBirchColor();
                if (biome.is(ModTags.Biomes.LESSER_COLOR_CHANGE_BIOMES)) {
                    birchColor = SeasonColorUtil.mixColours(colorProvider.getBirchColor(), -8345771, 0.75f);
                }
            }
            return birchColor;
        }, (Object[])new Block[]{Blocks.BIRCH_LEAVES});
    }
}

