/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.init;

import glitchcore.util.Environment;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import sereneseasons.api.SSBlocks;
import sereneseasons.api.SSItems;
import sereneseasons.init.ModClient;
import sereneseasons.item.CalendarItem;

public class ModItems {
    public static void setup(BiConsumer<ResourceLocation, Item> func) {
        ModItems.registerItems(func);
        ModItems.registerBlockItems(func);
        if (Environment.isClient()) {
            ModClient.registerItemProperties();
        }
    }

    public static void registerItems(BiConsumer<ResourceLocation, Item> func) {
        SSItems.SS_ICON = ModItems.registerItem(func, "ss_icon", new Item.Properties());
        SSItems.CALENDAR = ModItems.registerItem(func, "calendar", CalendarItem::new, new Item.Properties().stacksTo(1));
    }

    public static void registerBlockItems(BiConsumer<ResourceLocation, Item> func) {
        SSItems.SEASON_SENSOR = ModItems.registerBlock(func, SSBlocks.SEASON_SENSOR);
    }

    public static Item registerBlock(BiConsumer<ResourceLocation, Item> func, Block block) {
        return ModItems.registerBlock(func, block, BlockItem::new);
    }

    public static Item registerBlock(BiConsumer<ResourceLocation, Item> func, Block block, BiFunction<Block, Item.Properties, Item> factory) {
        return ModItems.registerBlock(func, block, factory, new Item.Properties());
    }

    public static Item registerBlock(BiConsumer<ResourceLocation, Item> func, Block block, BiFunction<Block, Item.Properties, Item> factory, Item.Properties properties) {
        return ModItems.registerItem(func, ModItems.blockIdToItemId((ResourceKey<Block>)block.builtInRegistryHolder().key()), (Item.Properties p_370785_) -> (Item)factory.apply(block, (Item.Properties)p_370785_), properties.useBlockDescriptionPrefix());
    }

    private static Item registerItem(BiConsumer<ResourceLocation, Item> func, ResourceKey<Item> key, Function<Item.Properties, Item> factory, Item.Properties properties) {
        Item item = factory.apply(properties.setId(key));
        func.accept(key.location(), item);
        return item;
    }

    private static Item registerItem(BiConsumer<ResourceLocation, Item> func, String name, Function<Item.Properties, Item> factory, Item.Properties properties) {
        return ModItems.registerItem(func, ModItems.itemId(name), factory, properties);
    }

    private static Item registerItem(BiConsumer<ResourceLocation, Item> func, String name, Item.Properties properties) {
        return ModItems.registerItem(func, ModItems.itemId(name), Item::new, properties);
    }

    private static ResourceKey<Item> blockIdToItemId(ResourceKey<Block> key) {
        return ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)key.location());
    }

    private static ResourceKey<Item> itemId(String name) {
        return ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"sereneseasons", (String)name));
    }
}

