/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.client;

import fuzs.illagerinvasion.client.gui.screens.inventory.ImbuingScreen;
import fuzs.illagerinvasion.client.init.ModelLayerLocations;
import fuzs.illagerinvasion.client.model.FirecallerModel;
import fuzs.illagerinvasion.client.model.InquisitorModel;
import fuzs.illagerinvasion.client.model.InvokerFangsModel;
import fuzs.illagerinvasion.client.model.InvokerModel;
import fuzs.illagerinvasion.client.render.entity.AlchemistRenderer;
import fuzs.illagerinvasion.client.render.entity.ArchivistRenderer;
import fuzs.illagerinvasion.client.render.entity.BasherRenderer;
import fuzs.illagerinvasion.client.render.entity.FirecallerRenderer;
import fuzs.illagerinvasion.client.render.entity.FlyingMagmaRenderer;
import fuzs.illagerinvasion.client.render.entity.InquisitorRenderer;
import fuzs.illagerinvasion.client.render.entity.InvokerFangsRenderer;
import fuzs.illagerinvasion.client.render.entity.InvokerRenderer;
import fuzs.illagerinvasion.client.render.entity.MarauderRenderer;
import fuzs.illagerinvasion.client.render.entity.NecromancerRenderer;
import fuzs.illagerinvasion.client.render.entity.ProvokerRenderer;
import fuzs.illagerinvasion.client.render.entity.SkullBoltRenderer;
import fuzs.illagerinvasion.client.render.entity.SorcererRenderer;
import fuzs.illagerinvasion.client.render.entity.SurrenderedRenderer;
import fuzs.illagerinvasion.client.render.entity.ThrownHatchetRenderer;
import fuzs.illagerinvasion.init.ModEntityTypes;
import fuzs.illagerinvasion.init.ModRegistry;
import fuzs.puzzleslib.api.client.core.v1.ClientModConstructor;
import fuzs.puzzleslib.api.client.core.v1.context.EntityRenderersContext;
import fuzs.puzzleslib.api.client.core.v1.context.LayerDefinitionsContext;
import fuzs.puzzleslib.api.client.core.v1.context.MenuScreensContext;
import fuzs.puzzleslib.api.client.core.v1.context.ParticleProvidersContext;
import fuzs.puzzleslib.api.client.core.v1.context.RenderTypesContext;
import java.util.function.Supplier;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.SkeletonModel;
import net.minecraft.client.model.geom.LayerDefinitions;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.MeshTransformer;
import net.minecraft.client.particle.FlameParticle;
import net.minecraft.client.particle.HeartParticle;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.entity.WitherSkullRenderer;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.Block;

public class IllagerInvasionClient
implements ClientModConstructor {
    public void onRegisterMenuScreens(MenuScreensContext context) {
        context.registerMenuScreen((MenuType)ModRegistry.IMBUING_MENU_TYPE.value(), ImbuingScreen::new);
    }

    public void onRegisterEntityRenderers(EntityRenderersContext context) {
        context.registerEntityRenderer((EntityType)ModEntityTypes.PROVOKER_ENTITY_TYPE.value(), ProvokerRenderer::new);
        context.registerEntityRenderer((EntityType)ModEntityTypes.INVOKER_ENTITY_TYPE.value(), InvokerRenderer::new);
        context.registerEntityRenderer((EntityType)ModEntityTypes.SURRENDERED_ENTITY_TYPE.value(), SurrenderedRenderer::new);
        context.registerEntityRenderer((EntityType)ModEntityTypes.NECROMANCER_ENTITY_TYPE.value(), NecromancerRenderer::new);
        context.registerEntityRenderer((EntityType)ModEntityTypes.SKULL_BOLT_ENTITY_TYPE.value(), SkullBoltRenderer::new);
        context.registerEntityRenderer((EntityType)ModEntityTypes.BASHER_ENTITY_TYPE.value(), BasherRenderer::new);
        context.registerEntityRenderer((EntityType)ModEntityTypes.SORCERER_ENTITY_TYPE.value(), SorcererRenderer::new);
        context.registerEntityRenderer((EntityType)ModEntityTypes.ARCHIVIST_ENTITY_TYPE.value(), ArchivistRenderer::new);
        context.registerEntityRenderer((EntityType)ModEntityTypes.INQUISITOR_ENTITY_TYPE.value(), InquisitorRenderer::new);
        context.registerEntityRenderer((EntityType)ModEntityTypes.MARAUDER_ENTITY_TYPE.value(), MarauderRenderer::new);
        context.registerEntityRenderer((EntityType)ModEntityTypes.ALCHEMIST_ENTITY_TYPE.value(), AlchemistRenderer::new);
        context.registerEntityRenderer((EntityType)ModEntityTypes.FIRECALLER_ENTITY_TYPE.value(), FirecallerRenderer::new);
        context.registerEntityRenderer((EntityType)ModEntityTypes.INVOKER_FANGS_ENTITY_TYPE.value(), InvokerFangsRenderer::new);
        context.registerEntityRenderer((EntityType)ModEntityTypes.HATCHET_ENTITY_TYPE.value(), ThrownHatchetRenderer::new);
        context.registerEntityRenderer((EntityType)ModEntityTypes.FLYING_MAGMA_ENTITY_TYPE.value(), FlyingMagmaRenderer::new);
    }

    public void onRegisterParticleProviders(ParticleProvidersContext context) {
        context.registerParticleProvider((ParticleType)ModRegistry.MAGIC_FLAME_PARTICLE_TYPE.value(), FlameParticle.Provider::new);
        context.registerParticleProvider((ParticleType)ModRegistry.NECROMANCER_BUFF_PARTICLE_TYPE.value(), HeartParticle.Provider::new);
    }

    public void onRegisterLayerDefinitions(LayerDefinitionsContext context) {
        MeshTransformer illagerMeshTransformer = MeshTransformer.scaling((float)0.9375f);
        Supplier<LayerDefinition> illagerLayerDefinition = () -> IllagerModel.createBodyLayer().apply(illagerMeshTransformer);
        context.registerLayerDefinition(ModelLayerLocations.ARCHIVIST, illagerLayerDefinition);
        context.registerLayerDefinition(ModelLayerLocations.ARCHIVIST_BOOK, BookModel::createBodyLayer);
        MeshTransformer surrenderedMeshTransformer = MeshTransformer.scaling((float)0.85f);
        context.registerLayerDefinition(ModelLayerLocations.SURRENDERED, () -> SkeletonModel.createBodyLayer().apply(surrenderedMeshTransformer));
        context.registerLayerDefinition(ModelLayerLocations.SURRENDERED_INNER_ARMOR, () -> LayerDefinition.create((MeshDefinition)HumanoidArmorModel.createBodyLayer((CubeDeformation)LayerDefinitions.INNER_ARMOR_DEFORMATION), (int)64, (int)32).apply(surrenderedMeshTransformer));
        context.registerLayerDefinition(ModelLayerLocations.SURRENDERED_OUTER_ARMOR, () -> LayerDefinition.create((MeshDefinition)HumanoidArmorModel.createBodyLayer((CubeDeformation)LayerDefinitions.OUTER_ARMOR_DEFORMATION), (int)64, (int)32).apply(surrenderedMeshTransformer));
        context.registerLayerDefinition(ModelLayerLocations.PROVOKER, illagerLayerDefinition);
        context.registerLayerDefinition(ModelLayerLocations.INVOKER, () -> InvokerModel.createBodyLayer(CubeDeformation.NONE).apply(illagerMeshTransformer));
        context.registerLayerDefinition(ModelLayerLocations.INVOKER_ARMOR, () -> InvokerModel.createBodyLayer(LayerDefinitions.INNER_ARMOR_DEFORMATION).apply(illagerMeshTransformer));
        context.registerLayerDefinition(ModelLayerLocations.NECROMANCER, () -> NecromancerRenderer.createBodyLayer(CubeDeformation.NONE).apply(illagerMeshTransformer));
        context.registerLayerDefinition(ModelLayerLocations.NECROMANCER_ARMOR, () -> NecromancerRenderer.createBodyLayer(LayerDefinitions.INNER_ARMOR_DEFORMATION).apply(illagerMeshTransformer));
        context.registerLayerDefinition(ModelLayerLocations.INVOKER_FANGS, InvokerFangsModel::createBodyLayer);
        context.registerLayerDefinition(ModelLayerLocations.INQUISITOR, () -> InquisitorModel.createBodyLayer().apply(MeshTransformer.scaling((float)1.1f)));
        context.registerLayerDefinition(ModelLayerLocations.SORCERER, () -> SorcererRenderer.createBodyLayer().apply(illagerMeshTransformer));
        context.registerLayerDefinition(ModelLayerLocations.FIRECALLER, () -> FirecallerModel.createBodyLayer().apply(illagerMeshTransformer));
        context.registerLayerDefinition(ModelLayerLocations.ALCHEMIST, () -> AlchemistRenderer.createBodyLayer().apply(illagerMeshTransformer));
        context.registerLayerDefinition(ModelLayerLocations.BASHER, illagerLayerDefinition);
        context.registerLayerDefinition(ModelLayerLocations.MARAUDER, illagerLayerDefinition);
        context.registerLayerDefinition(ModelLayerLocations.SKULL_BOLT, WitherSkullRenderer::createSkullLayer);
    }

    public void onRegisterBlockRenderTypes(RenderTypesContext<Block> context) {
        context.registerChunkRenderType((Object)((Block)ModRegistry.MAGIC_FIRE_BLOCK.value()), ChunkSectionLayer.CUTOUT);
    }
}

