/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.client.model;

import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.state.IllagerRenderState;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.monster.AbstractIllager;

public class CustomIllagerModel<T extends IllagerRenderState>
extends IllagerModel<T> {
    private final ModelPart head;
    private final ModelPart rightArm;
    private final ModelPart leftArm;

    public CustomIllagerModel(ModelPart root) {
        super(root);
        this.head = root.getChild("head");
        this.leftArm = root.getChild("left_arm");
        this.rightArm = root.getChild("right_arm");
    }

    public void setupAnim(T renderState) {
        super.setupAnim(renderState);
        if (((IllagerRenderState)renderState).armPose == AbstractIllager.IllagerArmPose.ATTACKING && !renderState.getMainHandItem().isEmpty()) {
            if (((IllagerRenderState)renderState).mainArm == HumanoidArm.RIGHT) {
                this.leftArm.xRot = Mth.cos((float)(((IllagerRenderState)renderState).walkAnimationPos * 0.19f)) * Math.min(0.5f, 2.0f * ((IllagerRenderState)renderState).walkAnimationSpeed * 0.5f);
                this.leftArm.zRot = 0.0f;
                this.leftArm.yRot = 0.0f;
                AnimationUtils.bobModelPart((ModelPart)this.leftArm, (float)((IllagerRenderState)renderState).ageInTicks, (float)-1.0f);
            } else {
                this.rightArm.xRot = Mth.cos((float)(((IllagerRenderState)renderState).walkAnimationPos * 0.19f + (float)Math.PI)) * Math.min(0.5f, 2.0f * ((IllagerRenderState)renderState).walkAnimationSpeed * 0.5f);
                this.rightArm.zRot = 0.0f;
                this.rightArm.yRot = 0.0f;
                AnimationUtils.bobModelPart((ModelPart)this.rightArm, (float)((IllagerRenderState)renderState).ageInTicks, (float)1.0f);
            }
        }
        if (((IllagerRenderState)renderState).armPose == AbstractIllager.IllagerArmPose.BOW_AND_ARROW && ((IllagerRenderState)renderState).mainArm == HumanoidArm.LEFT) {
            this.leftArm.yRot = 0.1f + this.head.yRot;
            this.leftArm.xRot = -1.5707964f + this.head.xRot;
            this.leftArm.zRot = 0.0f;
            this.rightArm.xRot = -0.9424779f + this.head.xRot;
            this.rightArm.yRot = this.head.yRot + 0.4f;
            this.rightArm.zRot = -1.5707964f;
        }
        if (((IllagerRenderState)renderState).armPose == AbstractIllager.IllagerArmPose.NEUTRAL) {
            AnimationUtils.bobArms((ModelPart)this.rightArm, (ModelPart)this.leftArm, (float)((IllagerRenderState)renderState).ageInTicks);
        }
    }
}

