/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.client.model;

import fuzs.illagerinvasion.client.model.CustomIllagerModel;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.IllagerRenderState;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.monster.AbstractIllager;

public class FirecallerModel
extends CustomIllagerModel<IllagerRenderState> {
    private final ModelPart body;
    private final ModelPart leftArm;
    private final ModelPart staff;

    public FirecallerModel(ModelPart root) {
        super(root);
        this.body = root.getChild("body");
        this.leftArm = root.getChild("left_arm");
        this.staff = this.leftArm.getChild("staff");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = IllagerModel.createBodyLayer().mesh;
        PartDefinition partDefinition = meshDefinition.getRoot().getChild("left_arm");
        partDefinition.addOrReplaceChild("staff", CubeListBuilder.create().texOffs(112, 0).addBox(0.0f, -4.9f, -9.5f, 1.0f, 28.0f, 1.0f), PartPose.rotation((float)1.2f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)128, (int)64);
    }

    @Override
    public void setupAnim(IllagerRenderState renderState) {
        super.setupAnim(renderState);
        this.body.xRot = 0.2f;
        if (!renderState.isRiding && renderState.armPose == AbstractIllager.IllagerArmPose.NEUTRAL) {
            this.leftArm.xRot = Mth.cos((float)(renderState.walkAnimationPos * 0.6662f)) * 0.5f * renderState.walkAnimationSpeed * 0.5f - 1.2f;
            AnimationUtils.bobModelPart((ModelPart)this.leftArm, (float)renderState.ageInTicks, (float)-1.0f);
            this.staff.visible = true;
        } else {
            this.staff.visible = false;
        }
    }
}

