/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.client.model;

import fuzs.illagerinvasion.client.model.CustomIllagerModel;
import fuzs.illagerinvasion.client.render.entity.state.StunnableIllagerRenderState;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.item.Items;

public class InquisitorModel
extends CustomIllagerModel<StunnableIllagerRenderState> {
    private final ModelPart head;
    private final ModelPart rightArm;
    private final ModelPart leftArm;

    public InquisitorModel(ModelPart root) {
        super(root);
        this.head = root.getChild("head");
        this.leftArm = root.getChild("left_arm");
        this.rightArm = root.getChild("right_arm");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = IllagerModel.createBodyLayer().mesh;
        PartDefinition partDefinition = meshDefinition.getRoot().getChild("right_arm");
        PartDefinition partDefinition1 = meshDefinition.getRoot().getChild("left_arm");
        partDefinition1.addOrReplaceChild("left_shoulder_pad", CubeListBuilder.create().texOffs(0, 64).mirror().addBox(-0.7f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(1.1f)), PartPose.ZERO);
        partDefinition.addOrReplaceChild("right_shoulder_pad", CubeListBuilder.create().texOffs(0, 64).addBox(-3.3f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(1.1f)), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)128);
    }

    @Override
    public void setupAnim(StunnableIllagerRenderState renderState) {
        super.setupAnim(renderState);
        if (renderState.armPose == AbstractIllager.IllagerArmPose.ATTACKING) {
            if (renderState.offHandItem.is(Items.SHIELD)) {
                if (renderState.mainArm == HumanoidArm.RIGHT) {
                    this.leftArm.xRot = -1.05f;
                    this.leftArm.yRot = 0.5235988f;
                }
                if (renderState.mainArm == HumanoidArm.LEFT) {
                    this.rightArm.xRot = 200.0f;
                    this.rightArm.yRot = -0.5235988f;
                }
            }
            if (renderState.isStunned) {
                this.head.zRot = 0.3f * Mth.sin((float)(0.45f * renderState.ageInTicks));
                this.head.xRot = 0.4f;
                this.rightArm.xRot = 200.0f;
                this.rightArm.yRot = 0.5235988f;
                this.leftArm.xRot = 200.0f;
                this.leftArm.yRot = -0.5235988f;
            }
        }
    }
}

