/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.client.model;

import fuzs.illagerinvasion.client.render.entity.NecromancerRenderer;
import fuzs.illagerinvasion.client.render.entity.state.InvokerRenderState;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.IllagerRenderState;

public class InvokerModel
extends IllagerModel<InvokerRenderState> {
    private final ModelPart body;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;

    public InvokerModel(ModelPart root) {
        super(root);
        this.body = root.getChild("body");
        this.leftLeg = root.getChild("left_leg");
        this.rightLeg = root.getChild("right_leg");
    }

    public static LayerDefinition createBodyLayer(CubeDeformation cubeDeformation) {
        MeshDefinition meshDefinition = NecromancerRenderer.createBodyLayer((CubeDeformation)cubeDeformation).mesh;
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 20).addBox(-4.0f, 0.0f, -3.0f, 8.0f, 12.0f, 6.0f, cubeDeformation).texOffs(0, 38).addBox(-4.0f, 0.0f, -3.0f, 8.0f, 22.0f, 6.0f, cubeDeformation.extend(0.5f)), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)128, (int)128);
    }

    public void setupAnim(InvokerRenderState renderState) {
        super.setupAnim((IllagerRenderState)renderState);
        this.rightLeg.xRot = this.leftLeg.xRot = 0.15f * renderState.floatAnimationSpeed;
        this.body.xRot = this.leftLeg.xRot;
    }
}

