/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.handler;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import fuzs.illagerinvasion.init.ModEntityTypes;
import fuzs.illagerinvasion.mixin.accessor.VillagerHostilesSensorAccessor;
import fuzs.illagerinvasion.world.entity.monster.Alchemist;
import fuzs.illagerinvasion.world.entity.monster.Archivist;
import fuzs.illagerinvasion.world.entity.monster.Basher;
import fuzs.illagerinvasion.world.entity.monster.Firecaller;
import fuzs.illagerinvasion.world.entity.monster.Inquisitor;
import fuzs.illagerinvasion.world.entity.monster.Invoker;
import fuzs.illagerinvasion.world.entity.monster.Marauder;
import fuzs.illagerinvasion.world.entity.monster.Necromancer;
import fuzs.illagerinvasion.world.entity.monster.Provoker;
import fuzs.illagerinvasion.world.entity.monster.Sorcerer;
import fuzs.illagerinvasion.world.entity.monster.Surrendered;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.npc.AbstractVillager;

public class VillagerGoalHandler {
    private static final List<AvoidVillagerEnemy<?>> VILLAGER_ENEMIES = ImmutableList.builder().add(new AvoidVillagerEnemy<Alchemist>(Alchemist.class, () -> ModEntityTypes.ALCHEMIST_ENTITY_TYPE.value(), 12.0f)).add(new AvoidVillagerEnemy<Archivist>(Archivist.class, () -> ModEntityTypes.ARCHIVIST_ENTITY_TYPE.value(), 12.0f)).add(new AvoidVillagerEnemy<Basher>(Basher.class, () -> ModEntityTypes.BASHER_ENTITY_TYPE.value(), 8.0f)).add(new AvoidVillagerEnemy<Firecaller>(Firecaller.class, () -> ModEntityTypes.FIRECALLER_ENTITY_TYPE.value(), 12.0f)).add(new AvoidVillagerEnemy<Inquisitor>(Inquisitor.class, () -> ModEntityTypes.INQUISITOR_ENTITY_TYPE.value(), 15.0f)).add(new AvoidVillagerEnemy<Invoker>(Invoker.class, () -> ModEntityTypes.INVOKER_ENTITY_TYPE.value(), 15.0f)).add(new AvoidVillagerEnemy<Marauder>(Marauder.class, () -> ModEntityTypes.MARAUDER_ENTITY_TYPE.value(), 12.0f)).add(new AvoidVillagerEnemy<Necromancer>(Necromancer.class, () -> ModEntityTypes.NECROMANCER_ENTITY_TYPE.value(), 15.0f)).add(new AvoidVillagerEnemy<Provoker>(Provoker.class, () -> ModEntityTypes.PROVOKER_ENTITY_TYPE.value(), 12.0f)).add(new AvoidVillagerEnemy<Sorcerer>(Sorcerer.class, () -> ModEntityTypes.SORCERER_ENTITY_TYPE.value(), 12.0f)).add(new AvoidVillagerEnemy<Surrendered>(Surrendered.class, () -> ModEntityTypes.SURRENDERED_ENTITY_TYPE.value(), 8.0f)).build();

    public static EventResult onEntityLoad(Entity entity, ServerLevel serverLevel, boolean isNewlySpawned) {
        if (entity.getType() == EntityType.WANDERING_TRADER) {
            for (AvoidVillagerEnemy<?> villagerEnemy : VILLAGER_ENEMIES) {
                villagerEnemy.addGoal((AbstractVillager)entity);
            }
        }
        return EventResult.PASS;
    }

    public static void init() {
        IdentityHashMap map = new IdentityHashMap((Map<EntityType<?>, Float>)VillagerHostilesSensorAccessor.illagerinvasion$getAcceptableDistanceFromHostiles());
        for (AvoidVillagerEnemy<?> villagerEnemy : VILLAGER_ENEMIES) {
            villagerEnemy.addAcceptableDistance(map::put);
        }
        VillagerHostilesSensorAccessor.illagerinvasion$setAcceptableDistanceFromHostiles(ImmutableMap.copyOf(map));
    }

    private record AvoidVillagerEnemy<T extends LivingEntity>(Class<T> clazz, Supplier<EntityType<T>> type, float acceptableDistance) {
        public void addGoal(AbstractVillager abstractVillager) {
            abstractVillager.goalSelector.addGoal(1, this.makeGoal(abstractVillager));
        }

        private Goal makeGoal(AbstractVillager abstractVillager) {
            return new AvoidEntityGoal((PathfinderMob)abstractVillager, this.clazz, this.acceptableDistance, 0.5, 0.5);
        }

        public void addAcceptableDistance(BiConsumer<EntityType<?>, Float> consumer) {
            consumer.accept(this.type.get(), Float.valueOf(this.acceptableDistance));
        }
    }
}

