/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.world.entity.monster;

import fuzs.illagerinvasion.world.entity.ai.goal.RangedBowAttackWithoutStrafingGoal;
import java.util.List;
import java.util.stream.StreamSupport;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.creaking.Creaking;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrownLingeringPotion;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Alchemist
extends AbstractIllager
implements RangedAttackMob {
    private static final EntityDataAccessor<Boolean> DATA_HOLDING_POTION = SynchedEntityData.defineId(Alchemist.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_HOLDING_BOW = SynchedEntityData.defineId(Alchemist.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public int potionCooldown = 160;

    public Alchemist(EntityType<? extends Alchemist> entityType, Level level) {
        super(entityType, level);
        this.xpReward = 10;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Creaking.class, 8.0f, 1.0, 1.2));
        this.goalSelector.addGoal(2, (Goal)new Raider.HoldGroundAttackGoal((AbstractIllager)this, 10.0f));
        this.goalSelector.addGoal(4, (Goal)new AlchemistRangedAttackGoal(this, 0.85, 20, 15.0f));
        this.goalSelector.addGoal(4, new RangedBowAttackWithoutStrafingGoal<Alchemist>(this, 0.85, 30, 15.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, EntitySpawnReason entitySpawnReason, @Nullable SpawnGroupData spawnGroupData) {
        spawnGroupData = super.finalizeSpawn(level, difficulty, entitySpawnReason, spawnGroupData);
        RandomSource randomSource = level.getRandom();
        this.populateDefaultEquipmentSlots(randomSource, difficulty);
        return spawnGroupData;
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        super.populateDefaultEquipmentSlots(random, difficulty);
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.BOW));
    }

    public void performRangedAttack(LivingEntity target, float pullProgress) {
        ItemStack itemStack = this.getItemBySlot(EquipmentSlot.MAINHAND);
        if (itemStack.is(Items.LINGERING_POTION) && ((PotionContents)itemStack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).potion().isPresent()) {
            Vec3 deltaMovement = target.getDeltaMovement();
            double d = target.getX() + deltaMovement.x - this.getX();
            double e = target.getEyeY() - 1.1 - this.getY();
            double f = target.getZ() + deltaMovement.z - this.getZ();
            double g = Math.sqrt(d * d + f * f);
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ThrownLingeringPotion thrownPotion = (ThrownLingeringPotion)Projectile.spawnProjectileUsingShoot(ThrownLingeringPotion::new, (ServerLevel)serverLevel, (ItemStack)itemStack, (LivingEntity)this, (double)d, (double)(e + g * 0.2), (double)f, (float)0.75f, (float)8.0f);
                thrownPotion.setXRot(thrownPotion.getXRot() + 20.0f);
            }
            this.playSound(SoundEvents.WITCH_THROW, 1.0f, 0.8f + this.random.nextFloat() * 0.4f);
            this.setBowState(true);
        } else {
            ItemStack itemInHand = this.getItemInHand(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, (Item)Items.BOW));
            ItemStack projectileItem = this.getProjectile(itemInHand);
            AbstractArrow abstractArrow = ProjectileUtil.getMobArrow((LivingEntity)this, (ItemStack)projectileItem, (float)pullProgress, (ItemStack)itemInHand);
            double d = target.getX() - this.getX();
            double e = target.getY(0.33) - abstractArrow.getY();
            double f = target.getZ() - this.getZ();
            double g = Math.sqrt(d * d + f * f);
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                Projectile.spawnProjectileUsingShoot((Projectile)abstractArrow, (ServerLevel)serverLevel, (ItemStack)projectileItem, (double)d, (double)(e + g * (double)0.2f), (double)f, (float)1.6f, (float)(14 - serverLevel.getDifficulty().getId() * 4));
            }
            this.playSound(SoundEvents.SKELETON_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        }
    }

    protected void addAdditionalSaveData(ValueOutput valueOutput) {
        valueOutput.putBoolean("BowState", this.getBowState());
        valueOutput.putBoolean("PotionState", this.getPotionState());
        super.addAdditionalSaveData(valueOutput);
    }

    protected void readAdditionalSaveData(ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        this.setPotionState(valueInput.getBooleanOr("PotionState", false));
        this.setBowState(valueInput.getBooleanOr("BowState", false));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_HOLDING_POTION, (Object)false);
        builder.define(DATA_HOLDING_BOW, (Object)true);
    }

    public boolean getPotionState() {
        return (Boolean)this.entityData.get(DATA_HOLDING_POTION);
    }

    public void setPotionState(boolean potionState) {
        this.entityData.set(DATA_HOLDING_POTION, (Object)potionState);
    }

    public boolean getBowState() {
        return (Boolean)this.entityData.get(DATA_HOLDING_BOW);
    }

    public void setBowState(boolean bowState) {
        this.entityData.set(DATA_HOLDING_BOW, (Object)bowState);
    }

    public SoundEvent getCelebrateSound() {
        return SoundEvents.EVOKER_CELEBRATE;
    }

    protected void customServerAiStep(ServerLevel serverLevel) {
        List nearbyClouds = serverLevel.getEntitiesOfClass(AreaEffectCloud.class, this.getBoundingBox().inflate(30.0), Entity::isAlive);
        for (AreaEffectCloud areaEffectCloud : nearbyClouds) {
            this.removeEffectsInCloud(areaEffectCloud);
        }
        --this.potionCooldown;
        if (this.potionCooldown <= 0) {
            this.setPotionState(true);
            this.potionCooldown = 160;
        }
        ItemStack mainHandItem = this.getItemInHand(InteractionHand.MAIN_HAND);
        if (this.getBowState() && mainHandItem.is(Items.LINGERING_POTION)) {
            this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.BOW));
            this.setPotionState(false);
        }
        if (this.getPotionState() && mainHandItem.is(Items.BOW)) {
            Holder potion = switch (this.random.nextInt(3)) {
                case 0 -> Potions.POISON;
                case 1 -> Potions.SLOWNESS;
                case 2 -> Potions.WEAKNESS;
                default -> throw new RuntimeException();
            };
            this.setItemSlot(EquipmentSlot.MAINHAND, PotionContents.createItemStack((Item)Items.LINGERING_POTION, (Holder)potion));
            this.setBowState(false);
        }
        super.customServerAiStep(serverLevel);
    }

    private void removeEffectsInCloud(AreaEffectCloud cloudEntity) {
        List nearbyIllagers = this.level().getEntitiesOfClass(AbstractIllager.class, cloudEntity.getBoundingBox().inflate(0.3), Entity::isAlive);
        for (LivingEntity entity : nearbyIllagers) {
            StreamSupport.stream(cloudEntity.potionContents.getAllEffects().spliterator(), false).findAny().map(MobEffectInstance::getEffect).ifPresent(arg_0 -> ((LivingEntity)entity).removeEffect(arg_0));
        }
    }

    public boolean canBeAffected(MobEffectInstance mobEffectInstance) {
        return mobEffectInstance.getEffect().is(MobEffects.POISON) && super.canBeAffected(mobEffectInstance);
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.ILLUSIONER_AMBIENT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.ILLUSIONER_DEATH;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.ILLUSIONER_HURT;
    }

    public void applyRaidBuffs(ServerLevel level, int wave, boolean unused) {
    }

    public AbstractIllager.IllagerArmPose getArmPose() {
        if (this.isAggressive()) {
            ItemStack itemInHand = this.getMainHandItem();
            if (itemInHand.is(Items.BOW)) {
                return AbstractIllager.IllagerArmPose.BOW_AND_ARROW;
            }
            if (itemInHand.is(Items.LINGERING_POTION)) {
                return AbstractIllager.IllagerArmPose.ATTACKING;
            }
        }
        return AbstractIllager.IllagerArmPose.CROSSED;
    }

    public boolean canFireProjectileWeapon(ProjectileWeaponItem projectileWeapon) {
        return projectileWeapon == Items.BOW;
    }

    class AlchemistRangedAttackGoal
    extends RangedAttackGoal {
        public AlchemistRangedAttackGoal(RangedAttackMob rangedAttackMob, double speedModifier, int attackInterval, float attackRadius) {
            super(rangedAttackMob, speedModifier, attackInterval, attackRadius);
        }

        public boolean canUse() {
            return super.canUse() && Alchemist.this.getMainHandItem().is(Items.LINGERING_POTION);
        }

        public void start() {
            super.start();
            Alchemist.this.setAggressive(true);
        }

        public void stop() {
            super.stop();
            Alchemist.this.setAggressive(false);
        }
    }
}

