/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.world.entity.monster;

import fuzs.illagerinvasion.init.ModSoundEvents;
import fuzs.illagerinvasion.world.entity.monster.Stunnable;
import fuzs.puzzleslib.api.item.v2.EnchantingHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.creaking.Creaking;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.WebBlock;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class Inquisitor
extends AbstractIllager
implements Stunnable {
    private static final EntityDataAccessor<Boolean> STUNNED = SynchedEntityData.defineId(Inquisitor.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> FINAL_ROAR = SynchedEntityData.defineId(Inquisitor.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public boolean finalRoar;
    public int stunTick = 40;
    public boolean isStunned;
    public int blockedCount;

    public Inquisitor(EntityType<? extends Inquisitor> entityType, Level world) {
        super(entityType, world);
        this.xpReward = 20;
        this.setPathfindingMalus(PathType.LEAVES, 0.0f);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Creaking.class, 8.0f, 1.0, 1.2));
        this.goalSelector.addGoal(4, (Goal)new Raider.HoldGroundAttackGoal((AbstractIllager)this, 10.0f));
        this.goalSelector.addGoal(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    protected void customServerAiStep(ServerLevel serverLevel) {
        if (!this.isNoAi() && GoalUtils.hasGroundPathNavigation((Mob)this)) {
            boolean isRaided = serverLevel.isRaided(this.blockPosition());
            ((GroundPathNavigation)this.getNavigation()).setCanOpenDoors(isRaided);
        }
        super.customServerAiStep(serverLevel);
    }

    public void aiStep() {
        ServerLevel serverLevel;
        Level level;
        if (this.horizontalCollision && (level = this.level()) instanceof ServerLevel && (serverLevel = (ServerLevel)level).getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
            AABB box = this.getBoundingBox().inflate(1.0);
            for (BlockPos blockPos : BlockPos.betweenClosed((int)Mth.floor((double)box.minX), (int)Mth.floor((double)box.minY), (int)Mth.floor((double)box.minZ), (int)Mth.floor((double)box.maxX), (int)Mth.floor((double)box.maxY), (int)Mth.floor((double)box.maxZ))) {
                Block block = serverLevel.getBlockState(blockPos).getBlock();
                if (!(block instanceof LeavesBlock) && !(block instanceof DoorBlock) && !(block instanceof WebBlock) || !serverLevel.destroyBlock(blockPos, true, (Entity)this) || !(block instanceof DoorBlock)) continue;
                this.playSound(SoundEvents.ZOMBIE_BREAK_WOODEN_DOOR, 1.0f, 1.0f);
            }
        }
        super.aiStep();
    }

    public boolean hasLineOfSight(Entity entity) {
        return !this.isStunned() && super.hasLineOfSight(entity);
    }

    protected boolean isImmobile() {
        return super.isImmobile() || this.isStunned();
    }

    protected void addAdditionalSaveData(ValueOutput valueOutput) {
        valueOutput.putBoolean("Stunned", this.isStunned);
        valueOutput.putBoolean("FinalRoar", this.finalRoar);
        super.addAdditionalSaveData(valueOutput);
    }

    protected void readAdditionalSaveData(ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        this.setStunnedState(valueInput.getBooleanOr("Stunned", false));
        this.setFinalRoarState(valueInput.getBooleanOr("FinalRoar", false));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(STUNNED, (Object)false);
        builder.define(FINAL_ROAR, (Object)false);
    }

    @Override
    public boolean isStunned() {
        return (Boolean)this.entityData.get(STUNNED);
    }

    public void setStunnedState(boolean isStunned) {
        this.entityData.set(STUNNED, (Object)isStunned);
    }

    public boolean getFinalRoarState() {
        return (Boolean)this.entityData.get(FINAL_ROAR);
    }

    public void setFinalRoarState(boolean hasdoneRoar) {
        this.entityData.set(FINAL_ROAR, (Object)hasdoneRoar);
    }

    public AbstractIllager.IllagerArmPose getArmPose() {
        if (this.isCelebrating()) {
            return AbstractIllager.IllagerArmPose.CELEBRATING;
        }
        if (this.isAggressive()) {
            return AbstractIllager.IllagerArmPose.ATTACKING;
        }
        return AbstractIllager.IllagerArmPose.NEUTRAL;
    }

    public SoundEvent getCelebrateSound() {
        return SoundEvents.VINDICATOR_CELEBRATE;
    }

    public void tick() {
        super.tick();
        if (this.isAlive() && this.isStunned()) {
            --this.stunTick;
            if (this.stunTick <= 0) {
                this.setStunnedState(false);
                this.stunTick = 40;
            }
        }
    }

    protected void blockedByItem(LivingEntity target) {
        this.knockBack((Entity)target);
        target.hurtMarked = true;
        target.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 200, 0));
    }

    private void knockBack(Entity entity) {
        double d = entity.getX() - this.getX();
        double e = entity.getZ() - this.getZ();
        double f = Math.max(d * d + e * e, 0.001);
        entity.push(d / f * 0.6, 0.4, e / f * 0.6);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, EntitySpawnReason entitySpawnReason, @Nullable SpawnGroupData spawnGroupData) {
        spawnGroupData = super.finalizeSpawn(level, difficulty, entitySpawnReason, spawnGroupData);
        ((GroundPathNavigation)this.getNavigation()).setCanOpenDoors(true);
        this.populateDefaultEquipmentSlots(level.getRandom(), difficulty);
        this.populateDefaultEquipmentEnchantments(level, level.getRandom(), difficulty);
        return spawnGroupData;
    }

    protected void populateDefaultEquipmentSlots(RandomSource randomSource, DifficultyInstance difficulty) {
        if (this.getCurrentRaid() == null) {
            this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.STONE_SWORD));
            this.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.SHIELD));
        }
    }

    public boolean hurtServer(ServerLevel serverLevel, DamageSource damageSource, float damageAmount) {
        Entity attacker = damageSource.getEntity();
        boolean hasShield = this.getOffhandItem().is(Items.SHIELD);
        if (this.isAggressive()) {
            if (attacker instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)attacker;
                ItemStack itemInHand = livingEntity.getMainHandItem();
                ItemStack shieldItem = this.getOffhandItem();
                if ((itemInHand.is(ItemTags.AXES) || attacker instanceof IronGolem || this.blockedCount >= 4) && shieldItem.is(Items.SHIELD)) {
                    this.playSound((SoundEvent)SoundEvents.SHIELD_BREAK.value(), 1.0f, 1.0f);
                    this.setStunnedState(true);
                    if (this.level() instanceof ServerLevel) {
                        serverLevel.sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, shieldItem), this.getX(), this.getY() + 1.5, this.getZ(), 30, 0.3, 0.2, 0.3, 0.003);
                        serverLevel.sendParticles((ParticleOptions)ParticleTypes.CLOUD, this.getX(), this.getY() + 1.0, this.getZ(), 30, 0.3, 0.3, 0.3, 0.1);
                        this.playSound(SoundEvents.RAVAGER_ROAR, 1.0f, 1.0f);
                        this.setItemSlot(EquipmentSlot.OFFHAND, ItemStack.EMPTY);
                    }
                    this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(8.0), entity -> !(entity instanceof Monster)).forEach(this::blockedByItem);
                    return super.hurtServer(serverLevel, damageSource, damageAmount);
                }
            }
            if (damageSource.getDirectEntity() instanceof AbstractArrow && hasShield) {
                this.playSound((SoundEvent)SoundEvents.SHIELD_BLOCK.value(), 1.0f, 1.0f);
                ++this.blockedCount;
                return false;
            }
            if (damageSource.getDirectEntity() instanceof LivingEntity && hasShield) {
                ++this.blockedCount;
                this.playSound((SoundEvent)SoundEvents.SHIELD_BLOCK.value(), 1.0f, 1.0f);
                return false;
            }
        }
        return super.hurtServer(serverLevel, damageSource, damageAmount);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSoundEvents.ILLAGER_BRUTE_AMBIENT_SOUND_EVENT.value();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSoundEvents.ILLAGER_BRUTE_DEATH_SOUND_EVENT.value();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)ModSoundEvents.ILLAGER_BRUTE_HURT_SOUND_EVENT.value();
    }

    public void applyRaidBuffs(ServerLevel serverLevel, int wave, boolean unused) {
        ItemStack mainHandItem = new ItemStack((ItemLike)Items.STONE_SWORD);
        ItemStack offHandItem = new ItemStack((ItemLike)Items.SHIELD);
        Raid raid = this.getCurrentRaid();
        if (this.random.nextFloat() <= raid.getEnchantOdds()) {
            int enchantmentLevel = wave > raid.getNumGroups(Difficulty.NORMAL) ? 2 : 1;
            Holder enchantment = EnchantingHelper.lookup((LevelReader)serverLevel, (ResourceKey)Enchantments.SHARPNESS);
            mainHandItem.enchant(enchantment, enchantmentLevel);
        }
        this.setItemSlot(EquipmentSlot.MAINHAND, mainHandItem);
        this.setItemSlot(EquipmentSlot.OFFHAND, offHandItem);
    }
}

