/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.world.entity.monster;

import fuzs.illagerinvasion.init.ModEntityTypes;
import fuzs.illagerinvasion.init.ModSoundEvents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.EvokerFangs;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;

public class InvokerFangs
extends EvokerFangs {
    public InvokerFangs(EntityType<? extends InvokerFangs> entityType, Level level) {
        super(entityType, level);
    }

    public InvokerFangs(Level level, double x, double y, double z, float yRot, int warmupDelay, LivingEntity owner) {
        this((EntityType<? extends InvokerFangs>)((EntityType)ModEntityTypes.INVOKER_FANGS_ENTITY_TYPE.value()), level);
        this.warmupDelayTicks = warmupDelay;
        this.setOwner(owner);
        this.setYRot(yRot * 57.295776f);
        this.setPos(x, y, z);
    }

    protected void dealDamageTo(LivingEntity target) {
        LivingEntity owner = this.getOwner();
        if (target.isAlive() && !target.isInvulnerable() && target != owner) {
            if (owner == null) {
                target.hurt(this.damageSources().magic(), 10.0f);
                target.push(0.0, 1.7, 0.0);
            } else if (!owner.isAlliedTo((Entity)target)) {
                ServerLevel serverLevel;
                DamageSource damageSource = this.damageSources().indirectMagic((Entity)this, (Entity)owner);
                Level level = this.level();
                if (level instanceof ServerLevel && target.hurtServer(serverLevel = (ServerLevel)level, damageSource, 6.0f)) {
                    EnchantmentHelper.doPostAttackEffects((ServerLevel)serverLevel, (Entity)target, (DamageSource)damageSource);
                    target.push(0.0, 0.6, 0.0);
                }
            }
        }
    }

    public void handleEntityEvent(byte id) {
        super.handleEntityEvent(id);
        if (id == 4) {
            this.clientSideAttackStarted = true;
            if (!this.isSilent()) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), (SoundEvent)ModSoundEvents.INVOKER_FANGS_SOUND_EVENT.value(), this.getSoundSource(), 1.0f, this.random.nextFloat() * 0.2f + 0.85f, false);
            }
        }
    }
}

