/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.world.entity.monster;

import fuzs.illagerinvasion.init.ModItems;
import fuzs.illagerinvasion.world.entity.projectile.ThrownHatchet;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.creaking.Creaking;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class Marauder
extends AbstractIllager
implements RangedAttackMob {
    private static final ResourceLocation SPEED_MODIFIER_AGGRESSIVE_ID = ResourceLocation.withDefaultNamespace((String)"aggressive");
    private static final AttributeModifier SPEED_MODIFIER_AGGRESSIVE = new AttributeModifier(SPEED_MODIFIER_AGGRESSIVE_ID, -0.06, AttributeModifier.Operation.ADD_VALUE);
    private static final EntityDataAccessor<Integer> RANGED_ATTACK_TIME = SynchedEntityData.defineId(Marauder.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final int RANGED_ATTACK_INTERVAL = 40;
    private int rangedAttackTimeO;

    public Marauder(EntityType<? extends Marauder> entityType, Level level) {
        super(entityType, level);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Creaking.class, 8.0f, 1.0, 1.2));
        this.goalSelector.addGoal(2, (Goal)new MarauderMeleeAttackGoal((PathfinderMob)this, 1.35, false));
        this.goalSelector.addGoal(3, (Goal)new MarauderRangedAttackGoal(this, 1.0, 40, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(RANGED_ATTACK_TIME, (Object)40);
    }

    public void aiStep() {
        super.aiStep();
        this.rangedAttackTimeO = (Integer)this.entityData.get(RANGED_ATTACK_TIME);
    }

    public float getChargingProgress(float partialTick) {
        float rangedAttackTime = Mth.lerp((float)partialTick, (float)this.rangedAttackTimeO, (float)((Integer)this.entityData.get(RANGED_ATTACK_TIME)).intValue());
        return 1.0f - Mth.clamp((float)(rangedAttackTime / 40.0f), (float)0.0f, (float)1.0f);
    }

    public void setRangedAttackTime(int attackTime) {
        this.entityData.set(RANGED_ATTACK_TIME, (Object)attackTime);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, EntitySpawnReason entitySpawnReason, @Nullable SpawnGroupData spawnGroupData) {
        spawnGroupData = super.finalizeSpawn(level, difficulty, entitySpawnReason, spawnGroupData);
        RandomSource randomSource = level.getRandom();
        this.populateDefaultEquipmentSlots(randomSource, difficulty);
        this.populateDefaultEquipmentEnchantments(level, randomSource, difficulty);
        return spawnGroupData;
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        super.populateDefaultEquipmentSlots(random, difficulty);
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack(ModItems.PLATINUM_INFUSED_HATCHET_ITEM));
    }

    public void performRangedAttack(LivingEntity target, float pullProgress) {
        ItemStack itemInHand = this.getMainHandItem();
        ItemStack itemStack = itemInHand.is(ModItems.PLATINUM_INFUSED_HATCHET_ITEM) ? itemInHand : new ItemStack(ModItems.PLATINUM_INFUSED_HATCHET_ITEM);
        ThrownHatchet thrownHatchet = new ThrownHatchet(this.level(), (LivingEntity)this, itemStack);
        double d = target.getX() - this.getX();
        double e = target.getY(0.3333333333333333) - thrownHatchet.getY();
        double f = target.getZ() - this.getZ();
        double g = Math.sqrt(d * d + f * f);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Projectile.spawnProjectileUsingShoot((Projectile)thrownHatchet, (ServerLevel)serverLevel, (ItemStack)itemStack, (double)d, (double)(e + g * (double)0.2f), (double)f, (float)1.6f, (float)(14 - this.level().getDifficulty().getId() * 4));
        }
        this.playSound((SoundEvent)SoundEvents.TRIDENT_THROW.value(), 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
    }

    public SoundEvent getCelebrateSound() {
        return SoundEvents.PILLAGER_CELEBRATE;
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader level) {
        return 0.0f;
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    protected void customServerAiStep(ServerLevel serverLevel) {
        super.customServerAiStep(serverLevel);
        AttributeInstance attributeInstance = this.getAttribute(Attributes.MOVEMENT_SPEED);
        if (!this.isAggressive()) {
            attributeInstance.removeModifier(SPEED_MODIFIER_AGGRESSIVE_ID);
        } else if (!attributeInstance.hasModifier(SPEED_MODIFIER_AGGRESSIVE_ID)) {
            attributeInstance.addTransientModifier(SPEED_MODIFIER_AGGRESSIVE);
        }
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.PILLAGER_AMBIENT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.PILLAGER_DEATH;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.PILLAGER_HURT;
    }

    public void applyRaidBuffs(ServerLevel level, int wave, boolean unused) {
    }

    public AbstractIllager.IllagerArmPose getArmPose() {
        return this.isAggressive() ? AbstractIllager.IllagerArmPose.ATTACKING : AbstractIllager.IllagerArmPose.NEUTRAL;
    }

    static class MarauderMeleeAttackGoal
    extends MeleeAttackGoal {
        public MarauderMeleeAttackGoal(PathfinderMob mob, double speedModifier, boolean followingTargetEvenIfNotSeen) {
            super(mob, speedModifier, followingTargetEvenIfNotSeen);
        }

        public boolean canUse() {
            return super.canUse() && this.mob.distanceToSqr((Entity)this.mob.getTarget()) < 16.0;
        }

        public boolean canContinueToUse() {
            return super.canContinueToUse() && this.mob.distanceToSqr((Entity)this.mob.getTarget()) < 36.0;
        }
    }

    class MarauderRangedAttackGoal
    extends RangedAttackGoal {
        public MarauderRangedAttackGoal(RangedAttackMob rangedAttackMob, double speedModifier, int attackInterval, float attackRadius) {
            super(rangedAttackMob, speedModifier, attackInterval, attackRadius);
        }

        public boolean canUse() {
            return super.canUse() && Marauder.this.getMainHandItem().is(ModItems.PLATINUM_INFUSED_HATCHET_ITEM);
        }

        public void start() {
            super.start();
            Marauder.this.setAggressive(true);
            Marauder.this.startUsingItem(InteractionHand.MAIN_HAND);
        }

        public void stop() {
            super.stop();
            Marauder.this.stopUsingItem();
            Marauder.this.setAggressive(false);
            Marauder.this.setRangedAttackTime(40);
        }

        public void tick() {
            super.tick();
            Marauder.this.setRangedAttackTime(this.attackTime);
        }
    }
}

