/*
 * Decompiled with CFR 0.152.
 */
package fuzs.netherchested.world.level.block.entity;

import fuzs.limitlesscontainers.api.limitlesscontainers.v1.LimitlessContainerUtils;
import fuzs.limitlesscontainers.api.limitlesscontainers.v1.MultipliedContainer;
import fuzs.netherchested.NetherChested;
import fuzs.netherchested.config.ServerConfig;
import fuzs.netherchested.init.ModRegistry;
import fuzs.netherchested.world.inventory.NetherChestMenu;
import fuzs.netherchested.world.level.block.entity.NamedBlockEntity;
import fuzs.puzzleslib.api.block.v1.entity.TickingBlockEntity;
import fuzs.puzzleslib.api.container.v1.ContainerMenuHelper;
import fuzs.puzzleslib.api.container.v1.ListBackedContainer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class NetherChestBlockEntity
extends NamedBlockEntity
implements LidBlockEntity,
TickingBlockEntity {
    public static final MutableComponent CONTAINER_TITLE = Component.translatable((String)"container.nether_chest");
    public static final int CONTAINER_SIZE = 54;
    private final ContainerOpenersCounter openersCounter = new NetherChestOpenersCounter();
    private final ChestLidController chestLidController = new ChestLidController();
    private final MultipliedContainer container = new NetherChestContainer();
    private final NonNullList<ItemStack> items = NonNullList.withSize((int)54, (Object)ItemStack.EMPTY);

    public NetherChestBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModRegistry.NETHER_CHEST_BLOCK_ENTITY_TYPE.value(), blockPos, blockState);
    }

    public void clientTick() {
        this.chestLidController.tickLid();
    }

    public float getOpenNess(float partialTicks) {
        return this.chestLidController.getOpenness(partialTicks);
    }

    public boolean triggerEvent(int id, int type) {
        if (id == 1) {
            this.chestLidController.shouldBeOpen(type > 0);
            return true;
        }
        return super.triggerEvent(id, type);
    }

    @Override
    public void loadAdditional(ValueInput valueInput) {
        super.loadAdditional(valueInput);
        this.items.clear();
        LimitlessContainerUtils.loadAllItems((ValueInput)valueInput, this.items);
    }

    @Override
    protected void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        LimitlessContainerUtils.saveAllItems((ValueOutput)valueOutput, this.items);
    }

    public void preRemoveSideEffects(BlockPos blockPos, BlockState blockState) {
        if (this.level != null) {
            LimitlessContainerUtils.dropContents((Level)this.level, (BlockPos)blockPos, (Container)this.container);
        }
    }

    @Override
    protected Component getDefaultName() {
        return CONTAINER_TITLE;
    }

    @Override
    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @Override
    protected void setItems(NonNullList<ItemStack> items) {
        ContainerMenuHelper.copyItemsIntoList(items, this.items);
    }

    @Override
    protected AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return new NetherChestMenu(containerId, inventory, this.container);
    }

    public void recheckOpen() {
        if (!this.remove) {
            this.openersCounter.recheckOpeners(this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public MultipliedContainer getContainer() {
        return this.container;
    }

    private class NetherChestOpenersCounter
    extends ContainerOpenersCounter {
        private NetherChestOpenersCounter() {
        }

        protected void onOpen(Level level, BlockPos pos, BlockState state) {
            level.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.ENDER_CHEST_OPEN, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
        }

        protected void onClose(Level level, BlockPos pos, BlockState state) {
            level.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.ENDER_CHEST_CLOSE, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
        }

        protected void openerCountChanged(Level level, BlockPos pos, BlockState state, int count, int openCount) {
            level.blockEvent(pos, state.getBlock(), 1, openCount);
        }

        protected boolean isOwnContainer(Player player) {
            NetherChestMenu netherChestMenu;
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            return abstractContainerMenu instanceof NetherChestMenu && (netherChestMenu = (NetherChestMenu)abstractContainerMenu).is((Container)NetherChestBlockEntity.this.container);
        }
    }

    private class NetherChestContainer
    implements ListBackedContainer,
    MultipliedContainer {
        private NetherChestContainer() {
        }

        public NonNullList<ItemStack> getContainerItems() {
            return NetherChestBlockEntity.this.items;
        }

        public void setChanged() {
            NetherChestBlockEntity.this.setChanged();
        }

        public void startOpen(Player player) {
            if (!NetherChestBlockEntity.this.remove && !player.isSpectator()) {
                NetherChestBlockEntity.this.openersCounter.incrementOpeners(player, NetherChestBlockEntity.this.getLevel(), NetherChestBlockEntity.this.getBlockPos(), NetherChestBlockEntity.this.getBlockState());
            }
        }

        public void stopOpen(Player player) {
            if (!NetherChestBlockEntity.this.remove && !player.isSpectator()) {
                NetherChestBlockEntity.this.openersCounter.decrementOpeners(player, NetherChestBlockEntity.this.getLevel(), NetherChestBlockEntity.this.getBlockPos(), NetherChestBlockEntity.this.getBlockState());
            }
        }

        public int getStackSizeMultiplier() {
            return ((ServerConfig)NetherChested.CONFIG.get(ServerConfig.class)).stackSizeMultiplier;
        }
    }
}

