/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyanvils.handler;

import fuzs.easyanvils.EasyAnvils;
import fuzs.easyanvils.config.ServerConfig;
import fuzs.easyanvils.handler.BlockConversionHandler;
import fuzs.easyanvils.network.ClientboundAnvilRepairMessage;
import fuzs.easyanvils.network.ClientboundOpenNameTagEditorMessage;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.puzzleslib.api.network.v4.MessageSender;
import fuzs.puzzleslib.api.network.v4.PlayerSet;
import fuzs.puzzleslib.api.network.v4.message.Message;
import fuzs.puzzleslib.api.util.v1.InteractionResultHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class ItemInteractionHandler {
    public static EventResultHolder<InteractionResult> onUseItem(Player player, Level level, InteractionHand hand) {
        if (!((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).miscellaneous.editNameTagsNoAnvil) {
            return EventResultHolder.pass();
        }
        ItemStack itemInHand = player.getItemInHand(hand);
        if (player.isShiftKeyDown() && itemInHand.is(Items.NAME_TAG)) {
            MessageSender.broadcast((PlayerSet)PlayerSet.ofEntity((Entity)player), (Message)new ClientboundOpenNameTagEditorMessage(hand, itemInHand.getHoverName()));
            return EventResultHolder.interrupt((Object)InteractionResultHelper.sidedSuccess((boolean)level.isClientSide));
        }
        return EventResultHolder.pass();
    }

    public static EventResultHolder<InteractionResult> onUseBlock(Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        BlockPos pos;
        BlockState state;
        if (!((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).miscellaneous.anvilRepairing) {
            return EventResultHolder.pass();
        }
        ItemStack stack = player.getItemInHand(hand);
        if (stack.is(Items.IRON_BLOCK) && (state = level.getBlockState(pos = hitResult.getBlockPos())).is(BlockTags.ANVIL) && ItemInteractionHandler.tryRepairAnvil(level, pos, state)) {
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            return EventResultHolder.interrupt((Object)InteractionResultHelper.sidedSuccess((boolean)level.isClientSide));
        }
        return EventResultHolder.pass();
    }

    public static boolean tryRepairAnvil(Level level, BlockPos blockPos, BlockState blockState) {
        BlockState repairedState = ItemInteractionHandler.getRepairedState(blockState);
        if (repairedState != null) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                level.setBlock(blockPos, repairedState, 2);
                MessageSender.broadcast((PlayerSet)PlayerSet.nearPosition((Vec3i)blockPos, (ServerLevel)serverLevel), (Message)new ClientboundAnvilRepairMessage(blockPos, repairedState));
            }
            return true;
        }
        return false;
    }

    @Nullable
    private static BlockState getRepairedState(BlockState blockState) {
        blockState = BlockConversionHandler.convertToVanillaBlock(blockState);
        blockState = ItemInteractionHandler.getVanillaRepairedState(blockState);
        return BlockConversionHandler.convertFromVanillaBlock(blockState);
    }

    @Nullable
    private static BlockState getVanillaRepairedState(@Nullable BlockState blockState) {
        if (blockState != null && blockState.is(Blocks.DAMAGED_ANVIL)) {
            return (BlockState)Blocks.CHIPPED_ANVIL.defaultBlockState().setValue((Property)AnvilBlock.FACING, (Comparable)((Direction)blockState.getValue((Property)AnvilBlock.FACING)));
        }
        if (blockState != null && blockState.is(Blocks.CHIPPED_ANVIL)) {
            return (BlockState)Blocks.ANVIL.defaultBlockState().setValue((Property)AnvilBlock.FACING, (Comparable)((Direction)blockState.getValue((Property)AnvilBlock.FACING)));
        }
        return null;
    }

    public static void onTakeAnvilOutputItemStack(ContainerLevelAccess containerLevelAccess, Player player, boolean onlyRenaming) {
        containerLevelAccess.execute((level, blockPos) -> {
            BlockState blockstate = level.getBlockState(blockPos);
            if (!player.getAbilities().instabuild && blockstate.is(BlockTags.ANVIL) && player.getRandom().nextFloat() < ItemInteractionHandler.computeAnvilBreakChance(onlyRenaming)) {
                BlockState damagedBlockState = AnvilBlock.damage((BlockState)blockstate);
                if (damagedBlockState == null) {
                    level.removeBlock(blockPos, false);
                    level.levelEvent(1029, blockPos, 0);
                } else {
                    level.setBlock(blockPos, damagedBlockState, 2);
                    level.levelEvent(1030, blockPos, 0);
                }
            } else {
                level.levelEvent(1030, blockPos, 0);
            }
        });
    }

    private static float computeAnvilBreakChance(boolean onlyRenaming) {
        if (((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).miscellaneous.riskFreeAnvilRenaming && onlyRenaming) {
            return 0.0f;
        }
        return (float)((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).miscellaneous.anvilBreakChance;
    }
}

