/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.reap;

import de.maxhenkel.reap.ReapMod;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

public class TreeEvents {
    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        ItemStack heldItem;
        Level world = (Level)event.getLevel();
        if (!((Boolean)ReapMod.SERVER_CONFIG.treeHarvest.get()).booleanValue() || world.isClientSide()) {
            return;
        }
        Player player = event.getPlayer();
        BlockPos pos = event.getPos();
        if (TreeEvents.canHarvest(pos, player, world, heldItem = player.getMainHandItem())) {
            TreeEvents.destroyTree(player, world, pos, heldItem);
        }
    }

    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (!((Boolean)ReapMod.SERVER_CONFIG.treeHarvest.get()).booleanValue() || !((Boolean)ReapMod.SERVER_CONFIG.dynamicTreeBreakingEnabled.get()).booleanValue()) {
            return;
        }
        Player player = event.getEntity();
        BlockPos pos = event.getPosition().orElse(null);
        if (pos == null) {
            return;
        }
        if (TreeEvents.canHarvest(pos, player, player.level(), player.getMainHandItem())) {
            List<BlockPos> connectedLogs = TreeEvents.getConnectedLogs(player.level(), pos);
            event.setNewSpeed((float)((double)event.getOriginalSpeed() / Math.min(1.0 + (Double)ReapMod.SERVER_CONFIG.dynamicTreeBreakingPerLog.get() * (double)connectedLogs.size(), (Double)ReapMod.SERVER_CONFIG.dynamicTreeBreakingMinSpeed.get())));
        }
    }

    public static boolean canHarvest(BlockPos pos, Player player, Level world, ItemStack heldItem) {
        if (player.getAbilities().instabuild) {
            return false;
        }
        if (player.isShiftKeyDown()) {
            return false;
        }
        if (ReapMod.SERVER_CONFIG.allowedTreeTools.stream().noneMatch(tag -> tag.contains(heldItem.getItem()))) {
            return false;
        }
        if (!TreeEvents.isLog(world, pos)) {
            return false;
        }
        if (!TreeEvents.isGround(world, pos.below())) {
            return false;
        }
        BlockState state = world.getBlockState(pos);
        return !state.getProperties().stream().anyMatch(p -> p.equals((Object)RotatedPillarBlock.AXIS)) || ((Direction.Axis)state.getValue((Property)RotatedPillarBlock.AXIS)).equals((Object)Direction.Axis.Y);
    }

    private static void destroyTree(Player player, Level world, BlockPos pos, ItemStack heldItem) {
        List<BlockPos> connectedLogs = TreeEvents.getConnectedLogs(world, pos);
        for (BlockPos logPos : connectedLogs) {
            TreeEvents.destroy(world, player, logPos, heldItem);
        }
    }

    private static List<BlockPos> getConnectedLogs(Level world, BlockPos pos) {
        BlockPosList positions = new BlockPosList();
        TreeEvents.collectLogs(world, pos, positions);
        return positions;
    }

    private static void collectLogs(Level world, BlockPos pos, BlockPosList positions) {
        int maxHarvestingCount = (Integer)ReapMod.SERVER_CONFIG.treeHarvestMaxCount.get();
        if (positions.size() >= maxHarvestingCount) {
            return;
        }
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos p = pos.offset(x, y, z);
                    if (!TreeEvents.isLog(world, p)) continue;
                    if (positions.size() <= maxHarvestingCount) {
                        if (!positions.add(p)) continue;
                        posList.add(p);
                        continue;
                    }
                    return;
                }
            }
        }
        for (BlockPos p : posList) {
            TreeEvents.collectLogs(world, p, positions);
        }
    }

    private static boolean isLog(Level world, BlockPos pos) {
        BlockState b = world.getBlockState(pos);
        return ReapMod.SERVER_CONFIG.logTypes.stream().anyMatch(tag -> tag.contains(b.getBlock()));
    }

    private static boolean isGround(Level world, BlockPos pos) {
        BlockState b = world.getBlockState(pos);
        return ReapMod.SERVER_CONFIG.groundTypes.stream().anyMatch(tag -> tag.contains(b.getBlock()));
    }

    private static void destroy(Level world, Player player, BlockPos pos, ItemStack heldItem) {
        if (heldItem != null) {
            heldItem.getItem().mineBlock(heldItem, world, world.getBlockState(pos), pos, (LivingEntity)player);
            world.destroyBlock(pos, true);
            player.causeFoodExhaustion(0.025f);
        }
    }

    private static class BlockPosList
    extends ArrayList<BlockPos> {
        private BlockPosList() {
        }

        @Override
        public boolean add(BlockPos pos) {
            if (!this.contains(pos)) {
                return super.add(pos);
            }
            return false;
        }

        @Override
        public boolean contains(Object o) {
            return this.stream().anyMatch(pos1 -> pos1.equals(o));
        }
    }
}

