/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.reap.corelib.codec;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public class CodecUtils {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    public static final Codec<ListTag> LIST_TAG_CODEC = Codec.PASSTHROUGH.comapFlatMap(dynamic -> {
        ListTag listTag;
        Tag tag = (Tag)dynamic.convert((DynamicOps)NbtOps.INSTANCE).getValue();
        return tag instanceof ListTag ? DataResult.success((Object)((listTag = (ListTag)tag) == dynamic.getValue() ? listTag.copy() : listTag)) : DataResult.error(() -> "Not a list tag: " + String.valueOf(tag));
    }, p_311526_ -> new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)p_311526_.copy()));

    public static <T> Optional<Tag> toNBT(Codec<T> codec, T object) {
        return codec.encodeStart((DynamicOps)NbtOps.INSTANCE, object).result();
    }

    public static <T> Optional<JsonElement> toJson(Codec<T> codec, T object) {
        return codec.encodeStart((DynamicOps)JsonOps.INSTANCE, object).result();
    }

    public static <T> Optional<String> toJsonString(Codec<T> codec, T object) {
        return CodecUtils.toJson(codec, object).map(arg_0 -> ((Gson)GSON).toJson(arg_0));
    }

    public static <T> Optional<T> fromNBT(Codec<T> codec, Tag nbt) {
        return codec.decode((DynamicOps)NbtOps.INSTANCE, (Object)nbt).result().map(Pair::getFirst);
    }

    public static <T> Optional<T> fromNBT(Codec<T> codec, String nbtString) {
        return codec.decode((DynamicOps)NbtOps.INSTANCE, (Object)StringTag.valueOf((String)nbtString)).result().map(Pair::getFirst);
    }

    public static <T> Optional<T> fromJson(Codec<T> codec, JsonElement json) {
        return codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).result().map(Pair::getFirst);
    }

    public static <T> Optional<T> fromJson(Codec<T> codec, String json) {
        JsonElement jsonelement = JsonParser.parseString((String)json);
        return jsonelement == null ? Optional.empty() : CodecUtils.fromJson(codec, jsonelement);
    }

    public static <U> StreamCodec<RegistryFriendlyByteBuf, Optional<U>> optionalStreamCodec(final StreamCodec<RegistryFriendlyByteBuf, U> streamCodec) {
        return new StreamCodec<RegistryFriendlyByteBuf, Optional<U>>(){

            public Optional<U> decode(RegistryFriendlyByteBuf buf) {
                if (buf.readBoolean()) {
                    return Optional.of(streamCodec.decode((Object)buf));
                }
                return Optional.empty();
            }

            public void encode(RegistryFriendlyByteBuf buf, Optional<U> t) {
                if (t.isPresent()) {
                    buf.writeBoolean(true);
                    streamCodec.encode((Object)buf, t.get());
                } else {
                    buf.writeBoolean(false);
                }
            }
        };
    }

    public static <U> StreamCodec<ByteBuf, Optional<U>> optionalStreamCodecByteBuf(final StreamCodec<ByteBuf, U> streamCodec) {
        return new StreamCodec<ByteBuf, Optional<U>>(){

            public Optional<U> decode(ByteBuf buf) {
                if (buf.readBoolean()) {
                    return Optional.of(streamCodec.decode((Object)buf));
                }
                return Optional.empty();
            }

            public void encode(ByteBuf buf, Optional<U> t) {
                if (t.isPresent()) {
                    buf.writeBoolean(true);
                    streamCodec.encode((Object)buf, t.get());
                } else {
                    buf.writeBoolean(false);
                }
            }
        };
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, List<T>> listStreamCodec(final StreamCodec<RegistryFriendlyByteBuf, T> codec) {
        return new StreamCodec<RegistryFriendlyByteBuf, List<T>>(){

            public void encode(RegistryFriendlyByteBuf buf, List<T> list) {
                buf.writeInt(list.size());
                for (Object t : list) {
                    codec.encode((Object)buf, t);
                }
            }

            public List<T> decode(RegistryFriendlyByteBuf buf) {
                int length = buf.readInt();
                ArrayList<Object> list = new ArrayList<Object>(length);
                for (int i = 0; i < length; ++i) {
                    Object t = codec.decode((Object)buf);
                    list.add(t);
                }
                return list;
            }
        };
    }

    public static <T> StreamCodec<ByteBuf, List<T>> listStreamCodecByteBuf(final StreamCodec<ByteBuf, T> codec) {
        return new StreamCodec<ByteBuf, List<T>>(){

            public void encode(ByteBuf buf, List<T> list) {
                buf.writeInt(list.size());
                for (Object t : list) {
                    codec.encode((Object)buf, t);
                }
            }

            public List<T> decode(ByteBuf buf) {
                int length = buf.readInt();
                ArrayList<Object> list = new ArrayList<Object>(length);
                for (int i = 0; i < length; ++i) {
                    Object t = codec.decode((Object)buf);
                    list.add(t);
                }
                return list;
            }
        };
    }
}

