/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.reap.corelib.death;

import com.mojang.serialization.Codec;
import de.maxhenkel.reap.corelib.codec.EquipmentItem;
import de.maxhenkel.reap.corelib.codec.ValueInputOutputUtils;
import de.maxhenkel.reap.corelib.item.ItemUtils;
import de.maxhenkel.reap.corelib.player.PlayerUtils;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class Death {
    private UUID id;
    private UUID playerUUID;
    private String playerName;
    private NonNullList<ItemStack> mainInventory = NonNullList.withSize((int)36, (Object)ItemStack.EMPTY);
    private NonNullList<ItemStack> armorInventory = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    private NonNullList<ItemStack> offHandInventory = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    private NonNullList<ItemStack> additionalItems = NonNullList.create();
    private EnumMap<EquipmentSlot, ItemStack> equipment = new EnumMap(EquipmentSlot.class);
    private long timestamp;
    private int experience;
    private double posX;
    private double posY;
    private double posZ;
    private String dimension;
    private byte model;

    private Death() {
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public NonNullList<ItemStack> getMainInventory() {
        return this.mainInventory;
    }

    public NonNullList<ItemStack> getArmorInventory() {
        return this.armorInventory;
    }

    public NonNullList<ItemStack> getOffHandInventory() {
        return this.offHandInventory;
    }

    public NonNullList<ItemStack> getAdditionalItems() {
        return this.additionalItems;
    }

    public EnumMap<EquipmentSlot, ItemStack> getEquipment() {
        return this.equipment;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getExperience() {
        return this.experience;
    }

    public double getPosX() {
        return this.posX;
    }

    public double getPosY() {
        return this.posY;
    }

    public double getPosZ() {
        return this.posZ;
    }

    public BlockPos getBlockPos() {
        return BlockPos.containing((double)this.posX, (double)this.posY, (double)this.posZ);
    }

    public String getDimension() {
        return this.dimension;
    }

    public byte getModel() {
        return this.model;
    }

    public String toString() {
        return "Death{name=" + this.playerName + "timestamp=" + this.timestamp + "}";
    }

    public static Death fromPlayer(Player player) {
        Death death = new Death();
        death.id = UUID.randomUUID();
        death.playerUUID = player.getUUID();
        death.playerName = player.getName().getString();
        for (int i = 0; i < death.mainInventory.size(); ++i) {
            death.mainInventory.set(i, (Object)((ItemStack)player.getInventory().getNonEquipmentItems().get(i)));
        }
        death.armorInventory.set(EquipmentSlot.FEET.getIndex(), (Object)player.getItemBySlot(EquipmentSlot.FEET));
        death.armorInventory.set(EquipmentSlot.LEGS.getIndex(), (Object)player.getItemBySlot(EquipmentSlot.LEGS));
        death.armorInventory.set(EquipmentSlot.CHEST.getIndex(), (Object)player.getItemBySlot(EquipmentSlot.CHEST));
        death.armorInventory.set(EquipmentSlot.HEAD.getIndex(), (Object)player.getItemBySlot(EquipmentSlot.HEAD));
        death.offHandInventory.set(0, (Object)player.getItemBySlot(EquipmentSlot.OFFHAND));
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack itemBySlot = player.getItemBySlot(slot);
            if (itemBySlot.isEmpty()) continue;
            death.equipment.put(slot, itemBySlot.copy());
        }
        death.timestamp = System.currentTimeMillis();
        death.experience = player.experienceLevel;
        death.posX = player.position().x;
        death.posY = player.position().y;
        death.posZ = player.position().z;
        death.dimension = player.level().dimension().location().toString();
        death.model = PlayerUtils.getModel(player);
        return death;
    }

    public void processDrops(Collection<ItemEntity> items) {
        List<ItemStack> drops = items.stream().filter(Objects::nonNull).map(ItemEntity::getItem).filter(itemStack -> !itemStack.isEmpty()).collect(Collectors.toList());
        this.processInventory(drops, this.mainInventory);
        this.processInventory(drops, this.armorInventory);
        this.processInventory(drops, this.offHandInventory);
        this.additionalItems.addAll(drops);
    }

    private void processInventory(List<ItemStack> drops, NonNullList<ItemStack> inventory) {
        for (int i = 0; i < inventory.size(); ++i) {
            ItemStack itemStack = (ItemStack)inventory.get(i);
            if (itemStack.isEmpty()) continue;
            if (drops.contains(itemStack)) {
                drops.remove(itemStack);
                continue;
            }
            inventory.set(i, (Object)ItemStack.EMPTY);
        }
    }

    public NonNullList<ItemStack> getAllItems() {
        NonNullList items = NonNullList.create();
        items.addAll(this.filterList((List<ItemStack>)this.mainInventory));
        items.addAll(this.filterList((List<ItemStack>)this.armorInventory));
        items.addAll(this.filterList((List<ItemStack>)this.offHandInventory));
        items.addAll(this.filterList((List<ItemStack>)this.additionalItems));
        return items;
    }

    private List<ItemStack> filterList(List<ItemStack> stacks) {
        return stacks.stream().filter(itemStack -> !itemStack.isEmpty()).collect(Collectors.toList());
    }

    public static Death read(HolderLookup.Provider registryAccess, CompoundTag tag) {
        TagValueInput valueInput = ValueInputOutputUtils.createValueInput("death", registryAccess, tag);
        return Death.read((ValueInput)valueInput);
    }

    public static Death read(ValueInput valueInput, String key) {
        return Death.read(valueInput.childOrEmpty(key));
    }

    public static Death read(ValueInput valueInput) {
        Death death = new Death();
        death.id = valueInput.read("Id", UUIDUtil.CODEC).orElseGet(UUID::randomUUID);
        death.playerUUID = valueInput.read("PlayerUuid", UUIDUtil.CODEC).orElse(Util.NIL_UUID);
        death.playerName = valueInput.getStringOr("PlayerName", "");
        ItemUtils.readInventory(valueInput, "MainInventory", death.mainInventory);
        ItemUtils.readInventory(valueInput, "ArmorInventory", death.armorInventory);
        ItemUtils.readInventory(valueInput, "OffHandInventory", death.offHandInventory);
        death.additionalItems = ItemUtils.readItemList(valueInput, "Items");
        Optional optionalEquipment = valueInput.read("Equipment", Codec.list(EquipmentItem.CODEC));
        if (optionalEquipment.isPresent()) {
            for (EquipmentItem equipmentItem : (List)optionalEquipment.get()) {
                death.equipment.put(equipmentItem.slot(), equipmentItem.item());
            }
        } else {
            Optional<CompoundTag> optionalEquipmentTag = ValueInputOutputUtils.getTag(valueInput, "Equipment");
            if (optionalEquipmentTag.isPresent()) {
                CompoundTag equipmentTag = optionalEquipmentTag.get();
                for (Map.Entry entry : equipmentTag.entrySet()) {
                    Object v = entry.getValue();
                    if (!(v instanceof CompoundTag)) continue;
                    CompoundTag tag = (CompoundTag)v;
                    try {
                        TagValueInput equipmentInput = ValueInputOutputUtils.createValueInput("death", valueInput.lookup(), tag);
                        Optional item = equipmentInput.read(ItemStack.MAP_CODEC);
                        EquipmentSlot slot = EquipmentSlot.byName((String)((String)entry.getKey()));
                        item.ifPresent(stack -> death.equipment.put(slot, (ItemStack)stack));
                    }
                    catch (Exception exception) {}
                }
            }
        }
        death.timestamp = valueInput.getLongOr("Timestamp", 0L);
        death.experience = valueInput.getIntOr("Experience", 0);
        death.posX = valueInput.getDoubleOr("PosX", 0.0);
        death.posY = valueInput.getDoubleOr("PosY", 0.0);
        death.posZ = valueInput.getDoubleOr("PosZ", 0.0);
        death.dimension = valueInput.getStringOr("Dimension", "minecraft:overworld");
        death.model = valueInput.getByteOr("Model", (byte)0);
        return death;
    }

    public void write(ValueOutput valueOutput) {
        this.write(valueOutput, true);
    }

    public void write(ValueOutput valueOutput, String key, boolean withItems) {
        this.write(valueOutput.child(key), withItems);
    }

    public void write(ValueOutput valueOutput, String key) {
        this.write(valueOutput, key, true);
    }

    public CompoundTag write(HolderLookup.Provider registryAccess) {
        return this.write(registryAccess, true);
    }

    public CompoundTag write(HolderLookup.Provider registryAccess, boolean withItems) {
        TagValueOutput valueOutput = ValueInputOutputUtils.createValueOutput("death", registryAccess);
        this.write((ValueOutput)valueOutput, withItems);
        return ValueInputOutputUtils.toTag(valueOutput);
    }

    public void write(ValueOutput valueOutput, boolean withItems) {
        valueOutput.store("Id", UUIDUtil.CODEC, (Object)this.id);
        valueOutput.store("PlayerUuid", UUIDUtil.CODEC, (Object)this.playerUUID);
        valueOutput.putString("PlayerName", this.playerName);
        if (withItems) {
            ItemUtils.saveInventory(valueOutput, "MainInventory", this.mainInventory);
            ItemUtils.saveInventory(valueOutput, "ArmorInventory", this.armorInventory);
            ItemUtils.saveInventory(valueOutput, "OffHandInventory", this.offHandInventory);
            ItemUtils.saveItemList(valueOutput, "Items", this.additionalItems);
        }
        ValueOutput.TypedOutputList equipmentOut = valueOutput.list("Equipment", EquipmentItem.CODEC);
        for (Map.Entry<EquipmentSlot, ItemStack> entry : this.equipment.entrySet()) {
            ItemStack equipmentStack = entry.getValue();
            if (equipmentStack.isEmpty()) continue;
            equipmentOut.add((Object)new EquipmentItem(entry.getKey(), equipmentStack));
        }
        valueOutput.putLong("Timestamp", this.timestamp);
        valueOutput.putInt("Experience", this.experience);
        valueOutput.putDouble("PosX", this.posX);
        valueOutput.putDouble("PosY", this.posY);
        valueOutput.putDouble("PosZ", this.posZ);
        valueOutput.putString("Dimension", this.dimension);
        valueOutput.putByte("Model", this.model);
    }

    public static class Builder {
        private Death death = new Death();

        public Builder(UUID playerUUID, UUID id) {
            this.death.dimension = "";
            this.death.playerName = "";
            this.death.playerUUID = playerUUID;
            this.death.id = id;
        }

        public Death build() {
            return this.death;
        }

        public Builder id(UUID uuid) {
            this.death.id = uuid;
            return this;
        }

        public Builder playerUUID(UUID uuid) {
            this.death.playerUUID = uuid;
            return this;
        }

        public Builder playerName(String name) {
            this.death.playerName = name;
            return this;
        }

        public Builder mainInventory(NonNullList<ItemStack> list) {
            this.death.mainInventory = list;
            return this;
        }

        public Builder armorInventory(NonNullList<ItemStack> list) {
            this.death.armorInventory = list;
            return this;
        }

        public Builder offHandInventory(NonNullList<ItemStack> list) {
            this.death.offHandInventory = list;
            return this;
        }

        public Builder additionalItems(NonNullList<ItemStack> list) {
            this.death.additionalItems = list;
            return this;
        }

        public Builder equipment(EnumMap<EquipmentSlot, ItemStack> list) {
            this.death.equipment = list;
            return this;
        }

        public Builder timestamp(long timestamp) {
            this.death.timestamp = timestamp;
            return this;
        }

        public Builder experience(int experience) {
            this.death.experience = experience;
            return this;
        }

        public Builder posX(double posX) {
            this.death.posX = posX;
            return this;
        }

        public Builder posY(double posY) {
            this.death.posY = posY;
            return this;
        }

        public Builder posZ(double posZ) {
            this.death.posZ = posZ;
            return this;
        }

        public Builder dimension(String dimension) {
            this.death.dimension = dimension;
            return this;
        }

        public Builder model(byte model) {
            this.death.model = model;
            return this;
        }
    }
}

