/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackTemplates;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.DatapackBackpackTemplateManager;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.command.BackpackTemplateArgumentType;
import net.p3pp3rf1y.sophisticatedbackpacks.command.DynamicCommand;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.RandHelper;

public class TemplateCommand {
    private TemplateCommand() {
    }

    static ArgumentBuilder<CommandSourceStack, ?> register(RegisterCommandsEvent event) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"template").then(DynamicCommand.register(event.getBuildContext()))).then(Commands.literal((String)"list").executes(context -> TemplateCommand.templateDetailComponent((CommandSourceStack)context.getSource())))).then(Commands.literal((String)"create").then(((RequiredArgumentBuilder)Commands.argument((String)"templateName", (ArgumentType)BackpackTemplateArgumentType.templateName()).executes(context -> TemplateCommand.createTemplate((CommandSourceStack)context.getSource(), BackpackTemplateArgumentType.getId((CommandContext<CommandSourceStack>)context, "templateName"), false))).then(Commands.argument((String)"override", (ArgumentType)BoolArgumentType.bool()).executes(context -> TemplateCommand.createTemplate((CommandSourceStack)context.getSource(), BackpackTemplateArgumentType.getId((CommandContext<CommandSourceStack>)context, "templateName"), BoolArgumentType.getBool((CommandContext)context, (String)"override"))))))).then(Commands.literal((String)"delete").then(Commands.argument((String)"templateName", (ArgumentType)BackpackTemplateArgumentType.templateName(false)).executes(context -> TemplateCommand.deleteTemplate((CommandSourceStack)context.getSource(), BackpackTemplateArgumentType.getId((CommandContext<CommandSourceStack>)context, "templateName")))))).then(Commands.literal((String)"give").then(((RequiredArgumentBuilder)Commands.argument((String)"templateName", (ArgumentType)BackpackTemplateArgumentType.templateName()).executes(context -> TemplateCommand.giveBackpackFromTemplate((CommandSourceStack)context.getSource(), BackpackTemplateArgumentType.getId((CommandContext<CommandSourceStack>)context, "templateName"), List.of(((CommandSourceStack)context.getSource()).getPlayer())))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(context -> TemplateCommand.giveBackpackFromTemplate((CommandSourceStack)context.getSource(), BackpackTemplateArgumentType.getId((CommandContext<CommandSourceStack>)context, "templateName"), EntityArgument.getPlayers((CommandContext)context, (String)"targets"))))))).then(Commands.literal((String)"export").then(((RequiredArgumentBuilder)Commands.argument((String)"templateName", (ArgumentType)BackpackTemplateArgumentType.templateName()).executes(context -> TemplateCommand.exportTemplate((CommandSourceStack)context.getSource(), BackpackTemplateArgumentType.getId((CommandContext<CommandSourceStack>)context, "templateName"), false))).then(Commands.argument((String)"delete", (ArgumentType)BoolArgumentType.bool()).executes(context -> TemplateCommand.exportTemplate((CommandSourceStack)context.getSource(), BackpackTemplateArgumentType.getId((CommandContext<CommandSourceStack>)context, "templateName"), true)))));
    }

    private static int templateDetailComponent(CommandSourceStack source) {
        source.sendSuccess(() -> Component.translatable((String)"commands.sophisticatedbackpacks.template.list.header"), false);
        source.sendSuccess(() -> Component.literal((String)"Datapack"), false);
        DatapackBackpackTemplateManager.getBackpackTemplates().keySet().forEach(templateName -> source.sendSuccess(() -> TemplateCommand.templateDetailComponent(templateName, false), false));
        source.sendSuccess(() -> Component.literal((String)"Local"), false);
        BackpackTemplates.getTemplateNames(false).forEach(templateName -> source.sendSuccess(() -> TemplateCommand.templateDetailComponent(templateName, true), false));
        return 0;
    }

    private static MutableComponent templateDetailComponent(ResourceLocation templateName, boolean includeNonDatapackMessages) {
        MutableComponent message = Component.literal((String)templateName.toString());
        message.append((Component)Component.literal((String)", "));
        message.append((Component)Component.translatable((String)"commands.sophisticatedbackpacks.template.list.give").withStyle(s -> s.withColor(ChatFormatting.GREEN).withClickEvent((ClickEvent)new ClickEvent.SuggestCommand("/sophisticatedbackpacks template give " + String.valueOf(templateName))).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.translatable((String)"commands.sophisticatedbackpacks.template.list.give.tooltip", (Object[])new Object[]{templateName.toString()})))));
        if (includeNonDatapackMessages) {
            message.append((Component)Component.literal((String)", "));
            message.append((Component)Component.translatable((String)"commands.sophisticatedbackpacks.template.list.export").withStyle(s -> s.withColor(ChatFormatting.AQUA).withClickEvent((ClickEvent)new ClickEvent.SuggestCommand("/sophisticatedbackpacks template export " + String.valueOf(templateName))).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.translatable((String)"commands.sophisticatedbackpacks.template.list.export.tooltip", (Object[])new Object[]{templateName.toString()})))));
            message.append((Component)Component.literal((String)", "));
            message.append((Component)Component.translatable((String)"commands.sophisticatedbackpacks.template.list.delete").withStyle(s -> s.withColor(ChatFormatting.RED).withClickEvent((ClickEvent)new ClickEvent.SuggestCommand("/sophisticatedbackpacks template delete " + String.valueOf(templateName))).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.translatable((String)"commands.sophisticatedbackpacks.template.list.delete.tooltip", (Object[])new Object[]{templateName.toString()})))));
        }
        return message;
    }

    private static int createTemplate(CommandSourceStack source, ResourceLocation templateName, boolean override) {
        if (!source.isPlayer()) {
            return 1;
        }
        ServerPlayer player = source.getPlayer();
        ItemStack backpack = player.getMainHandItem();
        if (!(backpack.getItem() instanceof BackpackItem)) {
            source.sendFailure((Component)Component.translatable((String)"commands.sophisticatedbackpacks.template.create.nobackpack"));
            return 2;
        }
        IBackpackWrapper backpackWrapper = BackpackWrapper.fromStack(backpack);
        Optional backpackUuid = backpackWrapper.getContentsUuid();
        if (backpackUuid.isEmpty() || InventoryHelper.isEmpty((IItemHandler)backpackWrapper.getInventoryHandler()) && InventoryHelper.isEmpty((IItemHandler)backpackWrapper.getUpgradeHandler())) {
            source.sendFailure((Component)Component.translatable((String)"commands.sophisticatedbackpacks.template.backpackempty"));
            return 3;
        }
        if (BackpackTemplates.getTemplateNames().contains(templateName) && !override) {
            source.sendFailure((Component)Component.translatable((String)"commands.sophisticatedbackpacks.template.create.alreadyexists", (Object[])new Object[]{templateName.toString()}));
            return 4;
        }
        BackpackTemplates.setBackpackTemplate(templateName, backpackWrapper);
        source.sendSuccess(() -> Component.translatable((String)"commands.sophisticatedbackpacks.template.create.success", (Object[])new Object[]{templateName.toString()}), true);
        return 0;
    }

    private static int deleteTemplate(CommandSourceStack source, ResourceLocation templateName) {
        BackpackTemplates.removeBackpackTemplate(templateName);
        source.sendSuccess(() -> Component.translatable((String)"commands.sophisticatedbackpacks.template.delete.success", (Object[])new Object[]{templateName.toString()}), true);
        return 0;
    }

    private static int giveBackpackFromTemplate(CommandSourceStack source, ResourceLocation templateName, Collection<ServerPlayer> players) {
        Optional<CompoundTag> templateData = BackpackTemplates.getBackpackTemplate(templateName);
        if (templateData.isEmpty()) {
            source.sendFailure((Component)Component.translatable((String)"commands.sophisticatedbackpacks.template.give.failure.notemplate", (Object[])new Object[]{templateName.toString()}));
            return 1;
        }
        ItemStack backpack = new ItemStack((ItemLike)BuiltInRegistries.ITEM.getValue((ResourceLocation)templateData.get().getString("backpackItemRegistryName").map(ResourceLocation::parse).orElse(null)));
        IBackpackWrapper wrapper = BackpackWrapper.fromStack(backpack);
        wrapper.setTemplate(templateName);
        players.forEach(p -> TemplateCommand.giveBackpackToPlayer(backpack.copy(), p));
        if (players.size() == 1) {
            source.sendSuccess(() -> Component.translatable((String)"commands.sophisticatedbackpacks.template.give.backpack.success", (Object[])new Object[]{((ServerPlayer)players.iterator().next()).getDisplayName()}), true);
        } else {
            source.sendSuccess(() -> Component.translatable((String)"commands.sophisticatedbackpacks.template.give.backpack.success", (Object[])new Object[]{players.size()}), true);
        }
        return 0;
    }

    private static void giveBackpackToPlayer(ItemStack backpack, ServerPlayer p) {
        ItemEntity itemEntity;
        boolean flag = p.getInventory().add(backpack);
        if (flag && backpack.isEmpty()) {
            backpack.setCount(1);
            itemEntity = p.drop(backpack, false);
            if (itemEntity != null) {
                itemEntity.makeFakeItem();
            }
            p.level().playSound(null, p.getX(), p.getY(), p.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, (RandHelper.getRandomMinusOneToOne((RandomSource)p.getRandom()) * 0.7f + 1.0f) * 2.0f);
            p.inventoryMenu.broadcastChanges();
        } else {
            ItemEntity itementity = p.drop(backpack, false);
            if (itementity != null) {
                itementity.setNoPickUpDelay();
                itementity.setThrower((Entity)p);
            }
        }
        itemEntity = p.drop(backpack, false);
        if (itemEntity != null) {
            itemEntity.makeFakeItem();
        }
    }

    private static int exportTemplate(CommandSourceStack source, ResourceLocation templateName, boolean deleteTemplate) {
        Optional<CompoundTag> templateData = BackpackTemplates.getBackpackTemplateNoDatapack(templateName);
        if (templateData.isEmpty()) {
            source.sendFailure((Component)Component.translatable((String)"commands.sophisticatedbackpacks.template.export.failure.notemplate", (Object[])new Object[]{templateName.toString()}));
            return 1;
        }
        BackpackTemplates.exportTemplate(source.getPlayer(), templateName, templateData.get());
        if (deleteTemplate) {
            BackpackTemplates.removeBackpackTemplate(templateName);
        }
        return 0;
    }
}

