/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.mixin.experimental.entity.block_caching.block_support;

import com.llamalad7.mixinextras.sugar.Local;
import java.util.Optional;
import net.caffeinemc.mods.lithium.common.entity.LithiumEntityCollisions;
import net.caffeinemc.mods.lithium.common.tracking.VicinityCache;
import net.caffeinemc.mods.lithium.common.tracking.VicinityCacheProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements VicinityCacheProvider,
LithiumEntityCollisions.SupportingBlockCollisionShapeProvider {
    @Shadow
    public Optional<BlockPos> mainSupportingBlockPos;

    @Shadow
    public abstract Level level();

    @Shadow
    protected abstract double getGravity();

    @Inject(method={"checkSupportingBlock(ZLnet/minecraft/world/phys/Vec3;)V"}, cancellable=true, at={@At(value="INVOKE", shift=At.Shift.BEFORE, target="Lnet/minecraft/world/entity/Entity;getBoundingBox()Lnet/minecraft/world/phys/AABB;")})
    private void cancelIfSkippable(boolean onGround, Vec3 movement, CallbackInfo ci) {
        VicinityCache bc;
        if ((movement == null || movement.x == 0.0 && movement.z == 0.0) && (bc = this.getUpdatedVicinityCache((Entity)this)).canSkipSupportingBlockSearch()) {
            ci.cancel();
        }
    }

    @Inject(method={"checkSupportingBlock(ZLnet/minecraft/world/phys/Vec3;)V"}, at={@At(value="INVOKE_ASSIGN", ordinal=0, shift=At.Shift.AFTER, target="Lnet/minecraft/world/level/Level;findSupportingBlock(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/AABB;)Ljava/util/Optional;")})
    private void cacheSupportingBlockSearch(CallbackInfo ci, @Local Optional<BlockPos> pos) {
        VicinityCache bc = this.lithium$getVicinityCache();
        if (bc.isTracking()) {
            bc.setCanSkipSupportingBlockSearch(true);
            if (pos.isPresent() && this.getGravity() > 0.0) {
                bc.cacheSupportingBlockState(this.level().getBlockState(pos.get()));
            }
        }
    }

    @Inject(method={"checkSupportingBlock(ZLnet/minecraft/world/phys/Vec3;)V"}, at={@At(value="INVOKE", ordinal=1, target="Lnet/minecraft/world/level/Level;findSupportingBlock(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/AABB;)Ljava/util/Optional;")})
    private void uncacheSupportingBlockSearch(CallbackInfo ci) {
        VicinityCache bc = this.lithium$getVicinityCache();
        if (bc.isTracking()) {
            bc.setCanSkipSupportingBlockSearch(false);
        }
    }

    @Inject(method={"checkSupportingBlock(ZLnet/minecraft/world/phys/Vec3;)V"}, at={@At(value="INVOKE", target="Ljava/util/Optional;empty()Ljava/util/Optional;", remap=false)})
    private void uncacheSupportingBlockSearch1(boolean onGround, Vec3 movement, CallbackInfo ci) {
        VicinityCache bc = this.lithium$getVicinityCache();
        if (bc.isTracking()) {
            bc.setCanSkipSupportingBlockSearch(false);
        }
    }

    @Override
    @Nullable
    public VoxelShape lithium$getCollisionShapeBelow() {
        BlockState cachedSupportingBlock;
        VicinityCache bc = this.getUpdatedVicinityCache((Entity)this);
        if (bc.isTracking() && (cachedSupportingBlock = bc.getCachedSupportingBlock()) != null && this.mainSupportingBlockPos.isPresent()) {
            BlockPos blockPos = this.mainSupportingBlockPos.get();
            return cachedSupportingBlock.getCollisionShape((BlockGetter)this.level(), blockPos, CollisionContext.of((Entity)((Entity)this))).move((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ());
        }
        return null;
    }
}

